block('b-campaign-stat-data').elem('metrics-cells-by-target').def()(function() {

    var rowCellsData = [],
        rowData = this.ctx.rowData,
        form = this.campStatCtx.form,
        metrika = (this.ctx.metrika === undefined) || this.ctx.metrika,
        spec = this.campStatCtx.spec || this.ctx.spec || 0,
        prefix = spec ? 'spec_' : '',
        fieldsLength = this.ctx.fields.length,
        fieldsIterator = 0,
        targetPostfixes = ['all', 0, 1],
        targetPostfixesLength = targetPostfixes.length,
        targetPostfixesIterator,
        targetPostfix,
        targetField,
        field,
        isPrice;

    (this.campStatCtx.all || this.ctx.all) && (prefix = 'all_');

    for (; fieldsIterator < fieldsLength; fieldsIterator++) {
        field = prefix + this.ctx.fields[fieldsIterator];
        isPrice = !/^(agoalnum|spec_agoalnum|all_agoalnum)$/.test(field);

        for (targetPostfixesIterator = 0; targetPostfixesIterator < targetPostfixesLength; targetPostfixesIterator++) {
            targetPostfix = targetPostfixes[targetPostfixesIterator];
            targetField = rowData[field + (targetPostfix == 'all' ? '' : '_' + targetPostfix)];

            form['target_' + targetPostfix] &&
                rowCellsData.push({
                    content: isPrice ?
                        this['price-or-ndash'](targetField) : this['value-or-ndash'](targetField),

                    metrika: metrika
                });
        }
    }

    return rowCellsData;
});
