block('b-campaign-stat-data').elem('phrases-cells').def()(function() {
    var rowData = this.ctx.rowData,
        campaign = this.data.campaign,
        phraseObject = rowData.phraseObject,
        isRelevanceMatch = rowData.contexttype == 'relevance-match',
        phrase = isRelevanceMatch ?
            '---autotargeting&nbsp;(' + iget2('b-campaign-stat-data', 'avtotargeting-111', 'автотаргетинг') + ')' :
            rowData.phrase,
        allowEditPhrasePrice = rowData.allowEditPhrasePrice && !!(rowData.renderPhrase && phraseObject),
        canEditPhrasePrice = allowEditPhrasePrice && phrase &&
            (+phraseObject.rank || phraseObject.is_retargeting || phraseObject.is_relevance_match),
        content;

    if (rowData.renderPhrase) {
        if (rowData.ContextType == u.dynamicMediaGroupsData.statisticsContextType) {
            content = rowData.phrase;
        } else if (rowData.ContextType == u.statisticsContextType.ret) {
            content = rowData.phrase;
            // ретаргетинг и интересы здесь не различаются - приходят в 1 списке
            // с ContextType == 2 и флагом is_retargeting == 1.
            // До https://st.yandex-team.ru/DIRECT-67121 у интересов приходила подпись
            // (Интерес), а у ретаргетинга (Условия подбора аудитории),
            // но в задаче убрали подпись у ретаргетинга.
            // См. https://st.yandex-team.ru/DIRECT-67121#1497878254000
            // В https://st.yandex-team.ru/DIRECT-67121#1497881762000 добавили флаг is_interest
            if (!rowData.is_interest) {
                content += ' (' + iget2('b-campaign-stat-data', 'uslovie-podbora-auditorii-112', 'Условие подбора аудитории') + ')';
            }
        } else if (rowData.ContextType == u.dynamicGroupsData.statisticsContextType) {
            var condition = this.data.used_dynamic_conditions[rowData.PhraseID] || {};

            content = {
                block: 'b-statistics-dynamic-condition',
                name: condition.name,
                condition: condition.condition
            };
        } else {
            content = {
                block: 'b-stat-phrase-minus-words',
                mix: [{
                    block: 'b-stat-table',
                    elem: 'stat-phrase-minus-words'
                }],
                phrase: phrase,
                isRelevanceMatch: isRelevanceMatch,
                limit: 20,
                showHelp: rowData.showHelp,
                campaignMinusWords: this.data.campaign.minus_words
            };
        }
    }

    return u._.compact([
        {
            content: content,
            canEditPhrasePrice: canEditPhrasePrice,
            data: canEditPhrasePrice && {
                campaign: campaign,
                phrase: phraseObject
            }
        },
        this.data.isCpmStat && {
            content: rowData.criterion_type ? {
                phrases: iget2('b-campaign-stat-data', 'phrase', 'фраза'),
                retargeting: iget2('b-campaign-stat-data', 'uslovie-podbora-auditorii', 'условие подбора аудитории'),
                'webpage-filter': iget2('b-campaign-stat-data', 'filtr-po-saitu', 'фильтр по сайту'),
                'feed-filter': iget2('b-campaign-stat-data', 'filtr-po-feedu', 'фильтр по фиду'),
                'mobile-content-interest': iget2('b-campaign-stat-data', 'interes-k-mob-app', 'интерес к мобильным приложениям'),
                'relevance-match': iget2('b-campaign-stat-data', 'autotargeting', 'автотаргетинг'),
                'reach-audience': iget2('b-campaign-stat-data', 'interesi-i-socdem', 'интересы и соцдем')
            }[rowData.criterion_type] : '&mdash;',
            elemMods: {
                'cell-format': 'format-date'
            }
        },
        {
            attrs: {
                colspan: this.targetsLength
            },
            elemMods: {
                'cell-format': 'format-date'
            },
            content: this.formatStatDate(rowData.Date, this.campStatCtx.group)
        }
    ]);
});
