block('b-campaign-stat-data').elem('reports-wizard-cells').def()(function() {

    var MINUS_WORDS_LIMIT = 80,
        data = this.data,
        rowCellsData = [],
        rowData = this.ctx.rowData,
        campStatCtx = this.campStatCtx,
        campsWithPreviewOnPage = this.campsWithPreviewOnPage || {},
        groupHash = campStatCtx.groupHash,
        phraseHasBuild = false,
        mediaType = data.campaign.mediaType,
        campRight = data.rights_on_campaigns && data.rights_on_campaigns[data.cid],
        hasCampEditRights = campRight && !!campRight.EditCamp,
        value,
        getPhrase = function() {
            if (phraseHasBuild ||
                (!groupHash.phrase && !groupHash.retargeting && !groupHash.dynamic && !groupHash.performance_filter)) {

                return '';
            }

            phraseHasBuild = true;
            value = data.phrase || rowData.phrase;

            if (rowData.ContextType == u.dynamicMediaGroupsData.statisticsContextType ||
                rowData.ContextType == u.statisticsContextType.ret) {
                return value;
            }

            if (rowData.ContextType == u.dynamicGroupsData.statisticsContextType) {
                var condition = data.used_dynamic_conditions[rowData.PhraseID] || {};

                return {
                    block: 'b-statistics-dynamic-condition',
                    name: condition.name,
                    condition: condition.condition
                };
            }
            return {
                content: {
                    block: 'b-statistic-phrase-minus-words',
                    phrase: value,
                    limit: MINUS_WORDS_LIMIT
                },
                elemMods: {
                    'cell-type': 'phrase-cell'
                }
            };
        },
        fields = {
            tag: groupHash.tag &&
                (rowData.tag_names ?
                    u.hellipCut(rowData.tag_names, campStatCtx.truncateLength) + '' : {
                        content: iget2('b-campaign-stat-data', 'bez-metki', 'без метки'),
                        grey: 'grey'
                    }),

            adgroup: groupHash.adgroup &&
                (!rowData.adgroup_name ?
                {
                    content: iget2('b-campaign-stat-data', 'bez-gruppy', 'без группы'),
                    grey: 'grey'
                } :
                [
                    iget2('b-campaign-stat-data', 'no', '№') + ' ' + rowData.adgroup_id,
                    ', ',
                    campsWithPreviewOnPage[data.cid] ? {
                        block: 'b-group-preview2-opener',
                        js: {
                            campaignMediaType: mediaType,
                            adgroupId: rowData.adgroup_id,
                            adgroupType: mediaType,
                            readonly: !hasCampEditRights
                        },
                        content: '&laquo;' + rowData.adgroup_name + '&raquo'
                    } : '&laquo;' + rowData.adgroup_name + '&raquo'
                ]),

            banner: groupHash.banner && {
                mods: {
                    'cell-type': 'banner-cell'
                },
                content: campsWithPreviewOnPage[data.cid] ? {
                    block: 'b-group-preview2-opener',
                    js: {
                        campaignMediaType: mediaType,
                        adgroupId: rowData.adgroup_id,
                        adgroupType: mediaType,
                        showOneBid: rowData.bid,
                        readonly: !hasCampEditRights
                    },
                    content: 'M-' + rowData.bid
                } : 'M-' + rowData.bid
            },

            page: groupHash.page && {
                content: [
                    (rowData.page_name || '&ndash;') +
                    (campStatCtx.form.use_page_id &&
                        hasLoginRights('super_control', 'support_control', 'superreader_control') ?
                            '(' + rowData.page_id + '-' + rowData.page_domain + ')' :
                            ''),
                    rowData.page_type
                ]
            },

            position: groupHash.position && {
                content: {
                    undefined: '&ndash;',
                    1: iget2('b-campaign-stat-data', 'specrazmeshchenie', 'спецразмещение'),
                    2: iget2('b-campaign-stat-data', 'prochee', 'прочее'),
                    102: iget2('b-campaign-stat-data', 'exclusive-position', 'эксклюзивное размещение'),
                    104: iget2('b-campaign-stat-data', 'suggest-position', 'реклама в саджесте')
                }[rowData.position]
            },

            image: groupHash.image && {
                content: rowData.has_image ? iget2('b-campaign-stat-data', 's-izobrazheniem', 'с изображением') : iget2('b-campaign-stat-data', 'bez-izobrazheniya', 'без изображения')
            },

            device_type: groupHash.device_type && {
                elemMods: {
                    'cell-type': 'image-cell'
                },
                content: {
                    desktop: iget2('b-campaign-stat-data', 'desktop', 'десктоп'),
                    mobile: iget2('b-campaign-stat-data', 'mobilnye', 'мобильные'),
                    tablet: iget2('b-campaign-stat-data', 'planshety', 'планшеты')
                }[rowData.device_type]
            },

            detailed_device_type: groupHash.detailed_device_type && {
                content: {
                    undefined: '&ndash;',
                    android: iget2('b-campaign-stat-data', 'android', 'Android'),
                    ios: iget2('b-campaign-stat-data', 'ios', 'iOS'),
                    other: iget2('b-campaign-stat-data', 'ne-opredelen', 'не определен')
                }[rowData.detailed_device_type]
            },

            connection_type: groupHash.connection_type && {
                content: {
                    undefined: '&ndash;',
                    mobile: iget2('b-campaign-stat-data', 'mobilnaya-svyaz', 'мобильная связь'),
                    stationary: iget2('b-campaign-stat-data', 'wi-fi', 'Wi-Fi')
                }[rowData.connection_type]
            },

            gender: groupHash.gender && {
                content: {
                    undefined: iget2('b-campaign-stat-data', 'ne-opredelen', 'не определен'),
                    male: iget2('b-campaign-stat-data', 'muzhskoy', 'мужской'),
                    female: iget2('b-campaign-stat-data', 'zhenskiy', 'женский')
                }[rowData.gender]
            },

            age: groupHash.age && {
                content: {
                    undefined: iget2('b-campaign-stat-data', 'ne-opredelen', 'не определен'),
                    '0-17': iget2('b-campaign-stat-data', 'mladshe-18', 'младше 18'),
                    '18-24': iget2('b-campaign-stat-data', 'ot-18-do-24', 'от 18 до 24'),
                    '25-34': iget2('b-campaign-stat-data', 'ot-25-do-34', 'от 25 до 34'),
                    '35-44': iget2('b-campaign-stat-data', 'ot-35-do-44', 'от 35 до 44'),
                    '45-': iget2('b-campaign-stat-data', 'starshe-45', 'старше 45'),
                    '45-54': iget2('b-campaign-stat-data', 'ot-45-do-54', 'от 45 до 54'),
                    '55-': iget2('b-campaign-stat-data', 'starshe-55', 'старше 55')
                }[rowData.age]
            },

            phrase: getPhrase(),
            performance_filter: getPhrase(),
            retargeting: getPhrase(),
            geo: groupHash.geo && rowData.region_name,
            date: groupHash.date && {
                elemMods: {
                    'cell-format': 'format-date'
                },
                content: this.formatStatDate(rowData.date, campStatCtx.group)
            }
        },
        cellMod = {
            type: 'reports-wizard-cell'
        };

    Object.keys(fields).forEach(function(name) {
        var cellItem;

        if (!fields[name]) return;

        if (name == 'page') {
            (rowCellsData = rowCellsData.concat(fields[name].content.map(function(val) {
                return {
                    content: val,
                    elemMods: cellMod
                };
            })));
        } else {
            rowCellsData.push(fields[name].content ?
                fields[name] : {
                    content: fields[name]
                });

            cellItem = rowCellsData[rowCellsData.length - 1];

            // DIRECT-45193
            if (name == 'age') {
                cellItem.elemMods = {
                    type: 'age'
                };
            } else {
                cellItem.elemMods = this.extend(cellItem.elemMods || {}, cellMod);
            }
        }
    }, this);

    rowCellsData[0].attrs = {
        colspan: applyCtx({
            elem: 'detailed-table-first-cell-colspan'
        })
    };

    return rowCellsData;
});
