block('b-campaign-stat-data').elem('row').def()(function() {
    var rowCellsData = [],
        rowData = this.ctx.rowData,
        metricsCell = this.specifiedMetricsCell || 'av_sum',
        spec = this.ctx.spec,
        all = this.ctx.all,
        last,
        showTrafficVolumeStatFields = u['traffic-volume'].showTrafficVolumeStatFields(this.data.mediaType),
        defaultFieldsArray = showTrafficVolumeStatFields ?
            ['shows', 'eshows', 'clicks', 'ctr', 'ectr', 'sum'] :
            ['shows', 'clicks', 'ctr', 'sum'],
        fields = this.specifiedFieldsArray || defaultFieldsArray;

    if (this.data.isCpmStat && !(this.specifiedFieldsArray || []).length) {
        fields.push('avg_cpm');
    }

    if (rowData) {
        this.ctx.additionalFields && (rowCellsData = applyCtx({
            elem: this.ctx.additionalFields.elemName,
            fields: this.ctx.additionalFields.names,
            rowData: rowData
        }));

        rowCellsData = rowCellsData.concat(applyCtx({
            elem: this.ctx.commonFieldsElemName || 'common-cells-by-target',
            fields: fields,
            spec: spec,
            all: all,
            rowData: rowData
        }));

        rowCellsData = rowCellsData.concat(applyCtx({
            elem: this.ctx.metricsFieldsElemName || 'metrics-cells-by-target',
            fields: [metricsCell],
            rowData: rowData,
            spec: spec,
            all: all,
            metrika: false
        }));

        // Ср. позиция показов и Ср. позиция кликов
        // используется в мастере отчетов
        // если выставлена галочка средняя позиция (with_avg_position)
        if (this.data.with_avg_position)
            rowCellsData = rowCellsData.concat(applyCtx({
                elem: 'metrics-cells-by-target', // используется просто как тип форматирования
                fields: ['fp_shows_avg_pos', 'avg_x', 'fp_clicks_avg_pos'],
                rowData: rowData,
                spec: spec,
                all: all,
                metrika: false
            }));

        last = rowCellsData[rowCellsData.length - 1];
        // спец вставка ячейки для кнопки метрики (чтобы таблица была ровной)
        last && rowCellsData.push({
            content: ''
        });

        if (!this.campStatCtx.directya) {
            rowCellsData = rowCellsData.concat(applyCtx({
                elem: this.ctx.metricsFieldsBuilderType || 'metrics-cells-by-target',
                fields: this.specifiedMetricsFieldsArray ||
                    ['adepth', 'agoalnum', 'aconv', 'agoalcost', 'agoalroi', 'agoalincome'],
                spec: spec,
                all: all,
                rowData: rowData
            }));
        }
    }

    return rowCellsData;
});
