block('b-campaign-stat-data').elem('table-body').elemMod('type', 'common').def()(function() {
    var data = this.data,
        ctx = this.ctx,
        mediaType = this.data.mediaType,
        rows = [],
        groups = {
            active: {
                state: 'active',
                descr: iget2('b-campaign-stat-data', 'aktivnye', 'активные'),
                prefix: '',
                showPrice: true
            },
            active_categories: {
                state: 'active',
                descr: iget2('b-campaign-stat-data', 'aktivnye', 'активные'),
                prefix: iget2('b-campaign-stat-data', 'rubrika', 'Рубрика:'),
                showPrice: true
            },
            bad_ctr: {
                state: 'disabled',
                descr: iget2('b-campaign-stat-data', 'otklyuchennye', 'отключенные'),
                prefix: '',
                showPrice: false
            },
            bad_ctr_categories: {
                state: 'disabled',
                descr: iget2('b-campaign-stat-data', 'otklyuchennye', 'отключенные'),
                prefix: iget2('b-campaign-stat-data', 'rubrika', 'Рубрика:'),
                showPrice: false
            },
            past: {
                state: 'disabled',
                descr: iget2('b-campaign-stat-data', 'udalennye', 'удаленные'),
                prefix: '',
                showPrice: false
            },
            past_categories: {
                state: 'disabled',
                descr: iget2('b-campaign-stat-data', 'udalennye', 'удаленные'),
                prefix: iget2('b-campaign-stat-data', 'rubrika', 'Рубрика:'),
                showPrice: false
            }
        },
        banner = ctx.statData,
        campaign = data.campaign,
        allowEditCamp = data.rights_on_campaigns[data.cid].EditCamp &&
            (data.allow_edit_camp || campaign.allow_edit_camp),
        allowEditPhrasePrice = mediaType != 'performance' && campaign.autobudget === 'No' && allowEditCamp &&
            !hasLoginRights('media_control'),
        PHRASE_MINUS_WORDS_LIMIT = 20;

    Object.keys(groups).forEach(function(groupKey) {
        var group = groups[groupKey],
            phrases = banner[groupKey] || [];

        phrases.forEach(function(phrase, index) {
            var bpid,
                phraseStat,
                phraseObject,
                canEditPhrasePrice,
                phraseContent,
                isRelevanceMatch;

            if (!phrase.PhraseID) return;

            bpid = banner.bid + '_' + (phrase.PhraseID || 0);
            isRelevanceMatch = phrase.ContextType == u.statisticsContextType.relevance_match,
            phraseStat = isRelevanceMatch ?
                '---autotargeting&nbsp;(' + iget2('b-campaign-stat-data', 'avtotargeting-111', 'автотаргетинг') + ')' :
                phrase.text || phrase.phrase;
            phraseObject = {
                phrase: phrase.phrase
            };

            if (phrase.ContextType == u.statisticsContextType.ret) {
                phraseObject = data.real_retargetings[bpid];
                phraseObject.id || (phraseObject.id = phrase.PhraseID);
                phraseObject.is_retargeting = true;
            } else if (data.real_phrases[bpid] &&
                (data.real_phrases[bpid].phrase == phraseStat || !data.real_phrases[bpid].numword)) {

                phraseObject = data.real_phrases[bpid];
                phraseObject.text_stat = phraseStat;
            }

            phraseObject = u._.extend({
                bannerId: banner.bid
            }, phraseObject);

            canEditPhrasePrice = allowEditPhrasePrice && group.showPrice &&
                (+phraseObject.rank || phraseObject.is_retargeting);

            if (phrase.ContextType == u.dynamicMediaGroupsData.statisticsContextType) {
                phraseContent = phraseStat;
            } else if (phrase.ContextType == u.dynamicGroupsData.statisticsContextType) {
                var condition = data.used_dynamic_conditions[phrase.PhraseID] || {};

                phraseContent = {
                    block: 'b-statistics-dynamic-condition',
                    name: condition.name,
                    condition: condition.condition
                };
            } else {
                phraseContent = {
                    block: 'b-stat-phrase-minus-words',
                    mix: [{
                        block: 'b-stat-table',
                        elem: 'stat-phrase-minus-words'
                    }],
                    phrase: phraseStat,
                    isRelevanceMatch: isRelevanceMatch,
                    limit: PHRASE_MINUS_WORDS_LIMIT,
                    isRetargeting: phrase.contexttype == 'retargeting',
                    isInterest: phrase.is_interest,
                    campaignMinusWords: campaign.minus_words,
                    showHelp: phrase.special_flag
                };
            }

            rows.push({
                elemMods: {
                    state: group.state
                },
                cols: [
                    {
                        content: !index && group.descr || '',
                        elemMods: {
                            content: 'status'
                        },
                        firstCol: false
                    },
                    {
                        elemMods: {
                            content: 'phrase'
                        },
                        attrs: {
                            colspan: ctx.firstCellColspan
                        },
                        content: [
                            group.prefix,
                            phraseContent
                        ],
                        canEditPhrasePrice: canEditPhrasePrice,
                        data: canEditPhrasePrice && {
                            campaign: campaign,
                            phrase: phraseObject
                        }
                    }
                ].concat(applyCtx({
                    elem: 'row',
                    rowData: phrase
                }))
            });
        }, this);
    }, this);

    // DIRECT-58847: статистика по фразам для Смартов считается неверно
    // поэтому убрали из статистики
    return mediaType == 'performance' ? [] : rows;
});
