// Для таблицы регионов
block('b-campaign-stat-data').elem('table-body').elemMod('type', 'geo').def()(function() {
    var statData = this.ctx.statData,
        regionsRows = [],
        buildRegionRow = function(region) {
            return {
                elemMods: {
                    level: region._level,
                    expanded: region._withChildren && region._level === 0 ? 'yes' : '', // первый уровень по умолчанию промаркирован раскрытым,
                    visible: region._level === 1 ? 'yes' : '' // второй уровень по умолчанию виден
                },
                level: region._level,
                cols: applyCtx({
                    elem: 'row',
                    elemMods: {
                        level: region._level
                    },
                    rowData: region,
                    additionalFields: {
                        names: ['name'],
                        elemName: 'regions-cells'
                    }
                })
            };
        }.bind(this),

        /**
         * Проверяет метод создающий таблицу регионов из дерева
         * рекурсивным обходом от корня к листьям
         * наполняет переменную regions одноуровневым списком
         * @param {Array} regionsTree корень дерева, массив верхних регионов
         * @param {Number} [level] текущая глубина обхода
         */
        pushRegions = function(regionsTree, level) {
            var oneOfSiblingsHasChildren = false;

            level = level || 0;

            regionsTree.some(function(region) {
                region.regions && (oneOfSiblingsHasChildren = true);

                return oneOfSiblingsHasChildren;
            });

            regionsTree.forEach(function(region) {
                // для каждого указываем уровень,
                // будет использован в JS коде для логики раскрытия закрытия
                region._level = level;

                // если есть дочерние то указываем региону, что есть дочерние
                region.regions && (region._withChildren = true);

                oneOfSiblingsHasChildren && (region._oneOfSiblingsHasChildren = true);

                // добавляем в список
                regionsRows.push(buildRegionRow(region));
                // если есть дочерние выполняем для его потомков операцию добавления
                if (region.regions) pushRegions(region.regions, level + 1);
            });
        };

    pushRegions(statData.regions);

    return regionsRows;
});
