block('b-campaign-stat-data').elem('table-body').elemMod('type', 'phrase-detail').def()(function() {
    var data = this.data,
        campaign = data.campaign,
        statData = this.ctx.statData,
        sortedData = statData.Dates || [],
        categoryDates = statData.CategoryDates || [],
        allowEditCamp = data.rights_on_campaigns[data.cid].EditCamp &&
            (data.allow_edit_camp || campaign.allow_edit_camp),
        allowEditPhrasePrice = campaign.mediaType != 'performance' && campaign.autobudget === 'No' && allowEditCamp &&
            !hasLoginRights('media_control'),
        bid = statData.bid,
        prevCatPhrase,
        prevPhrase;

    return sortedData
        .map(function(row) {
            var bpid = bid + '_' + row.PhraseID;

            row.renderPhrase = prevPhrase !== row.phrase;

            if (row.renderPhrase) {
                prevPhrase = row.phrase;
            }

            // если не условие ретаргетинга
            if (row.ContextType != u.statisticsContextType.ret && data.real_phrases[bpid]) {
                row.phraseObject = data.real_phrases[bpid].phrase === row.phrase && data.real_phrases[bpid];
            } else if (row.ContextType == u.statisticsContextType.relevance_match) {
                row.phraseObject = data.real_relevance_match[bid + '_11'];
                row.phraseObject.id || (row.phraseObject.id = row.PhraseID);
                row.phraseObject.is_relevance_match = 1;
            } else if (data.real_retargetings[bpid]) {
                row.phraseObject = data.real_retargetings[bpid];
                row.phraseObject.id || (row.phraseObject.id = row.PhraseID);
                row.phraseObject.is_retargeting = 1;
            }

            row.phraseObject && (row.phraseObject.bannerId = row.phraseObject.bid);

            return row;
        }, this)
        .concat(categoryDates.map(function(row) {
            row.renderPhrase = prevCatPhrase !== row.phrase;

            if (row.renderPhrase) {
                prevCatPhrase = row.phrase;

                row.phrase = [iget2('b-campaign-stat-data', 'rubrika-116', 'Рубрика'), ': ', row.phrase].join('');
            }

            return row;
        }, this))
        .map(function(row) {
            row.phraseObject && (row.allowEditPhrasePrice = allowEditPhrasePrice);

            return {
                isHoliday: row.holiday,
                elemMods: {
                    'start-phrase-row': row.renderPhrase ? 'yes' : ''
                },
                cols: applyCtx({
                    elem: 'row',
                    elemMods: this.ctx.elemMods,
                    rowData: row,
                    additionalFields: {
                        names: ['phrase'],
                        elemName: 'phrases-cells'
                    }
                }),
                cacheKey: !row.renderPhrase && (row.holiday ? 'phrase-detail-row-holiday' : 'phrase-detail-row')
            };
        }, this);
});
