block('b-campaign-stat-data').elem('table-body').def()(function() {
    var firstCellColspan = this.specifiedFirstCellColspan || (this.targetsLength + 1),
        sortedData = this.ctx.statData.dates;

    return Object.keys(sortedData || {}).map(function(key) {

        return {
            isHoliday: sortedData[key].holiday,
            cols: [
                {
                    elemMods: {
                        'cell-format': 'format-date'
                    },
                    content: this.formatStatDate(sortedData[key].date, this.campStatCtx.group),
                    attrs: {
                        colspan: firstCellColspan + (this.data.isCpmStat ? 1 : 0)
                    }
                }
            ].concat(
                applyCtx({
                    elem: 'row',
                    elemMods: this.ctx.elemMods,
                    rowData: sortedData[key]
                })),
            cacheKey: sortedData[key].holiday ? 'row-holiday' : 'row'
        };
    }.bind(this));
});
