block('b-campaign-stat-data').elem('table-foot').elemMod('type', 'phrase-detail').def()(function() {
    var data = this.data,
        sortBy = data.FORM.sort || 'date',
        reverse = +data.FORM.reverse,
        prevPhrase,
        specialPhrases = this.ctx.statData.SpecialPhrases || [],
        attrs = {
            colspan: this.targetsLength + 1 + (this.data.isCpmStat ? 1 : 0)
        },
        totalRow = {
            block: 'b-stat-table',
            elem: 'row',
            summary: true,
            isHoliday: this.ctx.statData.holiday,
            cols: [{
                content: iget2('b-campaign-stat-data', 'itogo-po-obyavleniyu', 'Итого по объявлению'),
                attrs: attrs
            }].concat(applyCtx({
                elem: 'row',
                all: !!specialPhrases.length,
                rowData: this.ctx.statData,
                elemMods: this.ctx.elemMods
            }))
        };

    if (specialPhrases.length) {
        specialPhrases.sort(function(a, b) {
            if (a.phrase > b.phrase) {
                return 1;
            }

            if (a.phrase < b.phrase) {
                return -1;
            }

            if (a[sortBy] > b[sortBy]) {
                return reverse ? -1 : 1;
            }

            if (a[sortBy] < b[sortBy]) {
                return reverse ? 1 : -1;
            }

            return 1;
        });

        return []
            .concat({
                block: 'b-stat-table',
                elem: 'row',
                summary: true,
                isHoliday: this.ctx.statData.holiday,
                cols: [{
                    content: iget2('b-campaign-stat-data', 'itogo', 'Итого'),
                    attrs: attrs
                }].concat(applyCtx({
                    elem: 'row',
                    rowData: this.ctx.statData,
                    elemMods: this.ctx.elemMods
                }))
            })
            .concat(specialPhrases.map(function(row) {
                row.renderPhrase = prevPhrase !== row.phrase;

                if (row.renderPhrase) {
                    prevPhrase = row.phrase;

                    row.showHelp = true;
                }

                return {
                    isHoliday: row.holiday,
                    elemMods: {
                        'start-phrase-row': row.renderPhrase ? 'yes' : ''
                    },
                    cols: applyCtx({
                        elem: 'row',
                        rowData: row,
                        additionalFields: {
                            names: ['phrase'],
                            elemName: 'phrases-cells'
                        }
                    })
                };
            }, this))
            .concat({
                block: 'b-stat-table',
                elem: 'row',
                summary: true,
                isHoliday: this.ctx.statData.holiday,
                cols: [{
                    content: iget2('b-campaign-stat-data', 'itogo-po-avtomaticheski-dobavlennym', 'Итого по автоматически добавленным фразам'),
                    attrs: attrs
                }].concat(applyCtx({
                    elem: 'row',
                    spec: true,
                    rowData: this.ctx.statData,
                    elemMods: this.ctx.elemMods
                }))
            })
            .concat(totalRow);
    }

    return totalRow;
});
