block('b-campaign-stat-data').elem('table-head').def()(function() {
    var statData = this.ctx.statData || {},
        mediaType = this.data.mediaType,
        formattedCurrency = this.campStatCtx.noDataFound ? '' : ', ' + this.currency,
        cellsItems = this.specifiedCellsItems || (this.ctx.cellsItems || []).concat(applyCtx({
            block: 'b-campaign-stat-data',
            elem: 'head-field-set',
            elemMods: {
                type: (this.mods || {}).type
            },
            formattedCurrency: formattedCurrency,
            mediaType: mediaType
        })),
        headerCells = [],
        defaultColumn = 'sorting',
        options = {
            anchor: statData.bid,
            defaultReverse: 1
        },
        cellOptions,
        lastCell = cellsItems[cellsItems.length - 1];

    // спец вставка ячейки для кнопки метрики (чтобы таблица была ровной)
    lastCell && cellsItems.push({
        hideTargets: true
    });

    if (!this.campStatCtx.directya) {
        cellsItems.push({
            id: 'adepth',
            title: iget2('b-campaign-stat-data', 'glubina-str', 'Глубина (стр.)')
        }, {
            id: 'agoalnum',
            title: iget2('b-campaign-stat-data', 'konversii', 'Конверсии')
        }, {
            id: 'aconv',
            title: iget2('b-campaign-stat-data', 'konversiya', 'Конверсия (%)')
        }, {
            id: 'agoalcost',
            title: iget2('b-campaign-stat-data', 'cena-nbsp-celi', 'Цена&nbsp;цели') + formattedCurrency
        });

        !this.excludeRoiCell && cellsItems.push({
            id: 'agoalroi',
            title: iget2('b-campaign-stat-data', 'rentabelnost', 'Рентабельность')
        });
        !this.excludeIncomeCell && cellsItems.push({
            id: 'agoalincome',
            title: iget2('b-campaign-stat-data', 'dohod', 'Доход') + formattedCurrency
        });
    }

    cellsItems.forEach(function(item) {

        cellOptions = {
            column: {
                id: item.id,
                title: item.title
            },
            sorting: item.sorting || {
                params: options,
                defaultColumn: defaultColumn
            },
            hideTargets: item.hideTargets,
            colspan: item.colspan,
            elemMods: item.elemMods
        };

        headerCells.push(applyCtx({
            elem: 'header-cells',
            cellOptions: cellOptions
        }));
    }, this);

    return [{
        elem: 'head',
        cols: headerCells
    }];
});
