block('b-campaign-stat-data').elem('total-table-common-cells').def()(function() {

    var data = this.data,
        form = this.campStatCtx.form,
        isCpmStat = this.data.isCpmStat,
        showTrafficVolumeStatFields = u['traffic-volume'].showTrafficVolumeStatFields(this.data.mediaType),
        notCpmStat = !isCpmStat,
        fieldNames = u._.compact(this.specifiedFieldNames || [
            notCpmStat && (this.campStatCtx.avGrouping ? 'av_grouping' : 'av_day'),
            isCpmStat && 'uniq_viewers',
            isCpmStat && 'avg_view_freq',
            'tshows',
            showTrafficVolumeStatFields && 'teshows',
            'tclicks',
            'tctr',
            showTrafficVolumeStatFields && 'tectr',
            'tsum',
            isCpmStat && 'tavg_cpm',
            'tav_sum'
        ]),
        fieldsToFormat =
            /^(av_day|av_grouping|tsum|tav_sum|av_sum|sum|tctr|ctr|ectr|tfp_shows_avg_pos|avg_x|tfp_clicks_avg_pos)$/,
        getTargetFieldValues = function(name) {
            var values = [],
                // nullToDash указывает нужно ли отображать ноль в ячейке как прочерк
                nullToDash = ['tav_sum', 'avg_x', 'tfp_shows_avg_pos', 'tfp_clicks_avg_pos'].indexOf(name) > -1;

            form.target_all && values.push(data[name] || 0);
            form.target_0 && values.push(data[name + '_0'] || 0);
            form.target_1 && values.push(data[name + '_1'] || 0);

            if (fieldsToFormat.test(name)) {
                values = values.map(function(item) {
                    return nullToDash && !item ?
                        '&ndash;' :
                        u.numberFormatter.format(item, {
                            exponentDelimiter: '&nbsp;'
                        });
                });
            }

            return values.length ? values : (nullToDash ? '&ndash;' : 0);
        },
        cellsValues = [];

    if (this.data.with_avg_position)
        fieldNames.push(
            'tfp_shows_avg_pos',
            'avg_x',
            'tfp_clicks_avg_pos'
        );

    fieldNames.forEach(function(name) {
        var values = getTargetFieldValues(name);

        name == 'tctr' && data.tctr > 100 &&
            values.splice(0, 1, ['&ndash;', {
                block: 'b-help-link',
                url: u.getHelpUrl('more-clicks')
            }]);

        cellsValues = cellsValues.concat(values);
    });

    return cellsValues.map(function(item) {
        return {
            content: item
        };
    });
});
