block('b-campaign-stat-data').elem('total-table-foot').def()(function() {
    var footContent = [];

    if (this.data.isCpmStat && this.campStatCtx.fraudShows) {
        if (hasLoginRights('super_control', 'superreader_control', 'support_control')) {
            footContent.push(
                iget2(
                    'b-campaign-stat-data',
                    'nedeystvitelnye-pokazi',
                    'Недействительные показы: {fraudShows}, из них подарено: {fraudGiftShows}',
                    {
                        fraudShows: this.campStatCtx.fraudShows,
                        fraudGiftShows: this.campStatCtx.fraudGiftShows,
                        context: 'fraudShows - 0; fraudGiftShows - 0'
                    }
                )
            );
        } else {
            footContent.push(
                iget2('b-campaign-stat-data', 'nedeystvitelnye-pokazi-0', 'Недействительные показы: {fraudShows}', {
                    fraudClicks: this.campStatCtx.fraudShows,
                    context: 'fraudShows - 0'
                })
            );
        }
    } else if (this.campStatCtx.fraudClicks) {
        if (hasLoginRights('super_control', 'superreader_control', 'support_control') && !this.data.isCpmStat) {
            footContent.push(
                iget2(
                    'b-campaign-stat-data',
                    'nedeystvitelnye-kliki-fraudclicks-0',
                    'Недействительные клики: {fraudClicks}, из них подарено: {fraudGiftClicks}',
                    {
                        fraudClicks: this.campStatCtx.fraudClicks,
                        fraudGiftClicks: this.campStatCtx.fraudGiftClicks,
                        context: 'fraudClicks - 0; fraudGiftClicks - 0'
                    }
                )
            );
        } else {
            footContent.push(
                iget2('b-campaign-stat-data', 'nedeystvitelnye-kliki-fraudclicks-0-113', 'Недействительные клики: {fraudClicks}', {
                    fraudClicks: this.campStatCtx.fraudClicks,
                    context: 'fraudClicks - 0'
                })
            );
        }

        footContent.push({
            block: 'b-help-link',
            mods: {
                type: 'modal'
            },
            width: 1110,
            url: u.getHelpUrl('antifraud-clicks')
        });
    }

    return footContent.length ? [{
        elem: 'footer',
        cols: [{
            content: {
                block: 'b-campaign-stat-data',
                elem: 'fraud-clicks',
                content: footContent
            },
            attrs: {
                colspan: this.ctx.totalCellsLength
            }
        }]
    }] : [];
});
