block('b-campaign-stat-data').elem('total-table-head').elemMod('type', 'phrase-detail').def()(function() {

    // DIRECT-58847: показы и ctr для Смартов считаются неверно,
    // поэтому их убрали из статистики
    var mediaType = this.data.mediaType,
        currency = this.currency,
        group = {
            day: iget2('b-campaign-stat-data', 'den', 'день'),
            week: iget2('b-campaign-stat-data', 'nedelyu', 'неделю'),
            month: iget2('b-campaign-stat-data', 'mesyac', 'месяц'),
            quarter: iget2('b-campaign-stat-data', 'kvartal', 'квартал'),
            year: iget2('b-campaign-stat-data', 'god', 'год')
        }[this.campStatCtx.group || 'day'],
        currencyData = {
            group: group,
            currency: currency
        },
        isCpmStat = this.data.isCpmStat,
        showTrafficVolumeStatFields = u['traffic-volume'].showTrafficVolumeStatFields(this.data.mediaType),
        notCpmStat = !isCpmStat;

    return applyNext({
        specifiedCellsCaptions: mediaType === 'performance' ? [
            {
                title: iget2('b-campaign-stat-data', 'vsego-po-kampanii', 'Всего по кампании')
            },
            {
                title: iget2('b-campaign-stat-data', 'sr-rashod-za-group', 'Ср. расход за {group}, {currency}', currencyData),
                elemMods: {
                    aligned: 'right'
                }
            },
            {
                id: 'clicks',
                title: iget2('b-campaign-stat-data', 'kliki', 'Клики')
            },
            {
                id: 'sum',
                title: iget2('b-campaign-stat-data', 'rashod-vsego-currency-u', 'Расход всего, {currency}', currencyData)
            },
            {
                id: 'av_sum',
                title: iget2('b-campaign-stat-data', 'sr-cena-klika-currency', 'Ср. цена клика, {currency}', currencyData)
            }
        ] : u._.compact([
            {
                title: iget2('b-campaign-stat-data', 'vsego-po-kampanii', 'Всего по кампании')
            },
            isCpmStat && {
                id: 'uniq_viewers',
                title: iget2('b-campaign-stat-data', 'ohvat', 'Охват'),
                elemMods: {
                    aligned: 'right'
                }
            },
            isCpmStat && {
                id: 'avg_view_freq',
                title: iget2('b-campaign-stat-data', 'st-chastota-pokazov', 'Ср. частота показов'),
                elemMods: {
                    aligned: 'right'
                }
            },
            notCpmStat && {
                title: iget2('b-campaign-stat-data', 'sr-rashod-za-group', 'Ср. расход за {group}, {currency}', currencyData),
                elemMods: {
                    aligned: 'right'
                }
            },
            {
                id: 'shows',
                title: iget2('b-campaign-stat-data', 'pokazy', 'Показы')
            },
            showTrafficVolumeStatFields && {
                id: 'eshows',
                title: iget2('b-campaign-stat-data', 'eshows', 'Взвешенные показы')
            },
            {
                id: 'clicks',
                title: iget2('b-campaign-stat-data', 'kliki', 'Клики')
            },
            {
                id: 'ctr',
                title: iget2('b-campaign-stat-data', 'ctr-114', 'CTR (%)')
            },
            showTrafficVolumeStatFields && {
                id: 'ectr',
                title: iget2('b-campaign-stat-data', 'wctr-114', 'wCTR (%)')
            },
            {
                id: 'sum',
                title: iget2('b-campaign-stat-data', 'rashod-vsego-currency-u', 'Расход всего, {currency}', currencyData)
            },
            isCpmStat && {
                id: 'avg_cpm',
                title: iget2('b-campaign-stat-data', 'sr-cena-tisachi-pokazov-v-valute', 'Ср. цена тысячи показов, {currency}', currencyData)
            },
            {
                id: 'av_sum',
                title: iget2('b-campaign-stat-data', 'sr-cena-klika-currency', 'Ср. цена клика, {currency}', currencyData)
            }
        ])
    });
});
