block('b-campaign-stat-data').elem('total-table-head').def()(function() {
    var currency = this.currency,
        targetsLength = this.targetsLength,
        attrs = targetsLength > 1 && {
            colspan: this.targetsLength
        },
        choosenTargets = this.choosenTargets,
        group = {
            day: iget2('b-campaign-stat-data', 'den', 'день'),
            week: iget2('b-campaign-stat-data', 'nedelyu', 'неделю'),
            month: iget2('b-campaign-stat-data', 'mesyac', 'месяц'),
            quarter: iget2('b-campaign-stat-data', 'kvartal', 'квартал'),
            year: iget2('b-campaign-stat-data', 'god', 'год')
        }[this.campStatCtx.group || 'day'],
        metricsCellsCaptions = this.specifiedMetricsCellsCaptions || [
            {
                id: 'adepth',
                title: iget2('b-campaign-stat-data', 'glubina-str', 'Глубина (стр.)')
            },
            {
                id: 'agoalnum',
                title: iget2('b-campaign-stat-data', 'konversii', 'Конверсии')
            },
            {
                id: 'aconv',
                title: iget2('b-campaign-stat-data', 'konversiya', 'Конверсия (%)')
            },
            {
                id: 'agoalcost',
                title: iget2('b-campaign-stat-data', 'cena-nbsp-celi-s', 'Цена&nbsp;цели, {foo}', {
                    foo: currency
                })
            },
            {
                id: 'agoalroi',
                title: iget2('b-campaign-stat-data', 'rentabelnost', 'Рентабельность')
            },
            {
                id: 'agoalincome',
                title: iget2('b-campaign-stat-data', 'dohod-s', 'Доход, {foo}', {
                    foo: currency
                })
            }
        ],
        metricsLastIndex = metricsCellsCaptions.length - 1,
        currencyData = {
            group: group,
            currency: currency
        },
        isCpmStat = this.data.isCpmStat,
        showTrafficVolumeStatFields = u['traffic-volume'].showTrafficVolumeStatFields(this.data.mediaType),
        notCpmStat = !isCpmStat,
        cellsCaptions = u._.compact(this.specifiedCellsCaptions || [
            {
                title: iget2('b-campaign-stat-data', 'vsego-po-kampanii', 'Всего по кампании')
            },
            isCpmStat && {
                id: 'uniq_viewers',
                title: iget2('b-campaign-stat-data', 'ohvat', 'Охват'),
                elemMods: {
                    aligned: 'right'
                }
            },
            isCpmStat && {
                id: 'avg_view_freq',
                title: iget2('b-campaign-stat-data', 'st-chastota-pokazov', 'Ср. частота показов'),
                elemMods: {
                    aligned: 'right'
                }
            },
            notCpmStat && {
                title: iget2('b-campaign-stat-data', 'sr-rashod-za-group', 'Ср. расход за {group}, {currency}', currencyData),
                elemMods: {
                    aligned: 'right'
                }
            },
            {
                id: 'shows',
                title: iget2('b-campaign-stat-data', 'pokazy', 'Показы')
            },
            showTrafficVolumeStatFields && {
                id: 'eshows',
                title: iget2('b-campaign-stat-data', 'eshows', 'Взвешенные показы')
            },
            {
                id: 'clicks',
                title: iget2('b-campaign-stat-data', 'kliki', 'Клики')
            },
            {
                id: 'ctr',
                title: iget2('b-campaign-stat-data', 'ctr-114', 'CTR (%)')
            },
            showTrafficVolumeStatFields && {
                id: 'ectr',
                title: iget2('b-campaign-stat-data', 'wctr-114', 'wCTR (%)')
            },
            {
                id: 'sum',
                title: iget2('b-campaign-stat-data', 'rashod-vsego-currency-u', 'Расход всего, {currency}', currencyData)
            },
            isCpmStat && {
                id: 'avg_cpm',
                title: iget2('b-campaign-stat-data', 'sr-cena-tisachi-pokazov-v-valute', 'Ср. цена тысячи показов, {currency}', currencyData)
            },
            {
                id: 'av_sum',
                title: iget2('b-campaign-stat-data', 'sr-cena-klika-currency', 'Ср. цена клика, {currency}', currencyData)
            }
        ]),
        needMetrikaHelp = this.needMetrikaHelp;

    if (this.data.with_avg_position)
        cellsCaptions.push({
            id: 'fp_shows_avg_pos',
            title: iget2('b-campaign-stat-data', 'sr-nbsp-poziciya-pokazov', 'Ср.&nbsp;позиция показов')
        }, {
            id: 'avg_x',
            title: iget2('b-campaign-stat-data', 'avg_x', 'Ср.&nbsp;объём трафика')
        }, {
            id: 'fp_clicks_avg_pos',
            title: iget2('b-campaign-stat-data', 'sr-nbsp-poziciya-klikov', 'Ср.&nbsp;позиция кликов')
        });

    cellsCaptions = cellsCaptions
        .map(function(item, i) {
            var cellData = {
                id: item.id,
                content: item.title,
                elemMods: item.elemMods || {}
            };

            if (i) {
                targetsLength > 1 && (cellData.content += '<br />' + choosenTargets);
                attrs && (cellData.attrs = attrs);

                cellData.elemMods.align = 'right';
            } else {
                // для Смартов колспан не нужен, там меньше колонок после DIRECT-58847
                this.ctx.firstCellColspan && this.data.mediaType != 'performance' && (cellData.attrs = {
                    colspan: this.ctx.firstCellColspan
                });
            }

            return cellData;
        }, this);

    cellsCaptions.push({
        metrika: true,
        content: {
            block: 'b-metrika-button',
            mods: targetsLength > 1 && {
                long: 'yes'
            },
            directya: this.campStatCtx.directya
        },
        attrs: {
            rowspan: 2
        }
    });

    if (!this.campStatCtx.directya) {
        cellsCaptions = cellsCaptions.concat(
            metricsCellsCaptions.map(function(item, i) {
                targetsLength > 1 && (item.title += '<br />' + choosenTargets);
                item = {
                    id: item.id,
                    metrika: true,
                    content: item.title,
                    elemMods: item.elemMods || {}
                };
                attrs && (item.attrs = attrs);

                item.elemMods.align = 'right';

                if (i == metricsLastIndex && !!needMetrikaHelp) {
                    item.help = {
                        title: iget2('b-campaign-stat-data', 'podrobnee-o-metrike', 'Подробнее о Метрике'),
                        url: u.getCommonHelpUrl('/direct/statistics/metrika.xml')
                    };
                }

                return item;
            })
        );
    }

    return {
        elem: 'head',
        isTotalHead: true,
        cols: cellsCaptions
    };
});
