block('b-campaign-stat-data').elem('total-table-metrics-cells').def()(function() {

    if (this.campStatCtx.directya) return [];

    var data = this.data,
        form = this.campStatCtx.form,
        metricsFieldsNames = this.specifiedMetricsFieldsNames ||
            ['tadepth', 'tagoalnum', 'taconv', 'tagoalcost', 'tagoalroi', 'tagoalincome'],
        targetsLength = !!form.target_all + !!form.target_0 + !!form.target_1,
        metricsValues = [];

    if (this.needMetrika && !this.campStatCtx.campaign.metrika_counters) {
        metricsValues.push({
            metrika: true,
            metrikaLink: true,
            content: {
                block: 'link',
                mix: [{
                    block: 'b-stat-table',
                    elem: 'metrika-link'
                }],
                content: iget2(
                    'b-campaign-stat-data',
                    'chtoby-uvidet-zdes-pokazateli',
                    'Чтобы увидеть здесь показатели&nbsp;&mdash;<br />установите Метрику'
                ),
                url: u.getUrl((hasLoginRights('agency_control') ? 'yaAddCounter' : 'yaShowUserCounters'), {
                    ulogin: this.campStatCtx.uidUrl.value
                }),
                target: '_blank'
            },
            attrs: {
                colspan: metricsFieldsNames.length * targetsLength
            }
        });
    } else {
        metricsFieldsNames.forEach(function(name) {
            var values = [],
                defaultValue = '&ndash;',
                formTargets = {
                    _all: 'target_all',
                    _0: 'target_0',
                    _1: 'target_1'
                };

            Object.keys(formTargets).forEach(function(postfix, i) {
                var value;

                if (form[formTargets[postfix]]) {
                    value = data[i ? name + postfix : name];

                    // значение может быть null, нужно обнулить чтобы получить 0.00
                    !+value && name == 'tagoalincome' && (value = 0);

                    values.push({
                        metrika: true,
                        content: (name == 'tagoalnum' || name == 'all_agoalnum') ?
                            this['value-or-ndash'](value) :
                            this['price-or-ndash'](value)
                    });
                }
            }, this);

            metricsValues = metricsValues.concat(values.length ? values : defaultValue);
        }, this);
    }

    return metricsValues;
});
