block('b-campaign-stat-data').elem('total-table').def()(function() {

    var ctx = this.ctx,
        firstCellColspan = applyCtx({
            elem: 'total-table-first-cell-colspan'
        }),
        totalTableBodyRow = {
            summary: 1,
            cols: [{
                content: this.campStatCtx.period,
                attrs: {
                    colspan: firstCellColspan || 1
                }
            }]
                .concat(applyCtx({
                    elem: 'total-table-common-cells',
                    elemMods: ctx.elemMods
                }))
                .concat(applyCtx({
                    elem: 'total-table-metrics-cells',
                    elemMods: ctx.elemMods
                }))
        },
        totalCellsLength = totalTableBodyRow.cols.length + (firstCellColspan > 1 ? firstCellColspan - 1 : 0),
        lastBodyRow = totalTableBodyRow.cols[totalTableBodyRow.cols.length - 1];

    this.needMetrika && !this.campStatCtx.directya && !this.campStatCtx.campaign.metrika_counters ?
        lastBodyRow && lastBodyRow.attrs && (totalCellsLength += lastBodyRow.attrs.colspan) :
        totalCellsLength++;

    totalTableBodyRow.isTotalTable = true;

    return {
        totalCellsLength: totalCellsLength,
        rows: (applyCtx([
            {
                elem: 'total-table-head',
                elemMods: ctx.elemMods,
                firstCellColspan: firstCellColspan
            },
            totalTableBodyRow
        ]) || [])
            .concat(applyCtx({
                elem: applyCtx({
                    elem: 'total-table-foot-elem-name'
                }),
                totalCellsLength: totalCellsLength
            }))
    };
});
