block('b-campaign-stat-data').mod('type', 'campdate').elem('table-title').replace()(function() {
    var data = this.data,
        ctx = this.ctx,
        statData = ctx.statData,
        statCtx = this.campStatCtx,
        showChartsManager = statData.dates && statData.dates.length > 0;

    return ctx.viewType === 'campaign' ?
        [
            {
                block: 'b-campaign-stat-data-title',
                mix: {
                    block: 'b-campaign-stat-data',
                    mods: {
                        type: 'campdate'
                    },
                    js: {
                        hasChart: !!statData.dates.length,
                        cid: statData.cid,
                        currency: ctx.currency,
                        target_all: this.data.target_all || 0,
                        target_1: this.data.target_1 || 0,
                        target_0: this.data.target_0 || 0
                    }
                },
                content: [
                    statData.metatype === 'ecom' ?
                        statData.name :
                        {
                            block: 'link',
                            mix: {
                                block: 'b-campaign-stat-data',
                                elem: 'campaign-name-link'
                            },
                            url: u.getUrl(
                                'showStat', {
                                    stat_type: 'moc',
                                    single_camp: 1,
                                    with_auto_added_phrases: 1,
                                    ulogin: data.user_login,
                                    cid: statData.cid,
                                    y1: data.y1,
                                    m1: data.m1,
                                    d1: data.d1,
                                    y2: data.y2,
                                    m2: data.m2,
                                    d2: data.d2
                                }
                            ),
                            content: statData.name
                        },
                    {
                        block: 'b-campaign-stat-data',
                        elem: 'campaign-cid',
                        content: '&nbsp;(' + statData.cid + ')'
                    },
                    statData.ManagerFio && {
                        block: 'b-campaign-stat-data',
                        elem: 'campaign-manager',
                        content: ', ' + iget2('b-campaign-stat-data', 'menedzher-115', 'менеджер') + ': ' + statData.ManagerFio
                    }
                ]
            },
            showChartsManager && {
                block: 'b-campaign-stat-data-title',
                elem: 'chart',
                content: {
                    block: 'b-stat-table',
                    elem: 'campaign-table-title',
                    //DIRECT-54001: передаем currency для графиков статистики
                    currency: ctx.currency,

                    // для новых графиков DIRECT-59325
                    chartsManager: {
                        cid: statData.cid,
                        groupByDate: statCtx.group,
                        withNds: statCtx.withNds,
                        date: statCtx.date
                    }
                }
            }
        ] :
        [
            {
                block: 'b-stat-table',
                elem: 'campaign-table-title',
                caption: iget2('b-campaign-stat-data', 'po-vsem-kampaniyam', 'По всем кампаниям'),
                //DIRECT-54001: передаем currency для графиков статистики
                currency: ctx.currency,

                // для новых графиков DIRECT-59325
                chartsManager: showChartsManager && {
                    // в статистике по выбранным кампаниям cid будет строкой, где кампании разделены через «, »
                    cid: statData.cid,
                    view: data.USER_OPTIONS.stat_chart_view || undefined,
                    groupByDate: statCtx.group,
                    withNds: statCtx.withNds,
                    date: statCtx.date
                }
            }
        ];
});
