block('b-campaign-stat-data').mod('type', 'common')(

    def()(function() {
        // для вкладки Общая статистика нет возможности выбора
        ['target_all', 'target_0', 'target_1'].forEach(function(item) {
            delete this.ctx.form[item];
        }, this);

        return applyNext();
    }),

    content()(function() {
        var totalTableData = applyCtx({
                elem: 'total-table'
            }),
            data = [
                {
                    rows: totalTableData.rows
                },
                {
                    tbodyMods: {
                        type: 'space'
                    }
                }
            ],
            totalCellsLength = totalTableData.totalCellsLength;

        return {
            block: 'b-stat-table',
            mods: {
                type: 'common'
            },
            content: data.concat(applyCtx({
                block: 'b-campaign-stat-data',
                elem: 'detailed-table',
                elemMods: {
                    type: 'common'
                },
                totalCellsLength: totalCellsLength
            }))
        };
    }),

    elem('total-table-head').def()(function() {
        var head = applyNext();

        // удаляем Средний расход
        head.cols.splice(1, 1);

        return head;
    }),

    elem('total-table').def()(function() {
        // для Смартов colspan убрали после DIRECT-58847
        // а в DIRECT-61807 оказалось, что их все-таки больше и колспан нужен
        var firstCellColspan = this.data.mediaType == 'performance' ? 1 : 3,
            totalTableBodyRow = {
                summary: 1,
                cols: [{
                    content: this.campStatCtx.period,
                    attrs: {
                        colspan: firstCellColspan
                    }
                }]
                    .concat(applyCtx({
                        elem: 'total-table-common-cells',
                        elemMods: {
                            type: 'common'
                        }
                    }))
                    .concat(applyCtx({
                        elem: 'total-table-metrics-cells'
                    }))
            },
            totalCellsLength = totalTableBodyRow.cols.length + firstCellColspan - 1,
            lastBodyRow = totalTableBodyRow.cols[totalTableBodyRow.cols.length - 1];

        this.needMetrika && !this.campStatCtx.directya && !this.campStatCtx.campaign.metrika_counters ?
            lastBodyRow && lastBodyRow.attrs && (totalCellsLength += lastBodyRow.attrs.colspan) :
            totalCellsLength++;

        totalTableBodyRow.isTotalTable = true;

        return {
            totalCellsLength: totalCellsLength,
            rows: (applyCtx([
                {
                    elem: 'total-table-head',
                    firstCellColspan: firstCellColspan
                },
                totalTableBodyRow
            ]) || [])
                .concat(applyCtx({
                    elem: 'total-table-foot',
                    totalCellsLength: totalCellsLength
                }))
                .concat(applyCtx({
                    elem: 'total-table-foot-reports-wizard',
                    totalCellsLength: totalCellsLength
                }))
        };
    }),

    elem('total-table-foot').def()(function() {
        var totalCellsLength = this.ctx.totalCellsLength,
            footer = applyNext(),
            campaign = this.campStatCtx.campaign,
            footerEl,
            metrikaRow,
            colsCount;

        footer.length == 0 && footer.push({ cols: [], elemMods: { 'border-bottom': 'no' } });
        footerEl = footer[0];

        if (campaign.metrika_counters) {
            metrikaRow = applyCtx({
                block: 'b-campaign-stat-data',
                elem: 'metrika-row',
                elemMod: this.ctx.mod,
                campaign: this.campStatCtx.campaign,
                noGoal: true,
                noGroup: true
            });

            footerEl.cols.push(metrikaRow);
            colsCount = footerEl.cols.length;

            footerEl.cols[0].attrs.colspan = colsCount > 1 ? totalCellsLength - colsCount : totalCellsLength;
        }

        return footer;
    })
);
