block('b-campaign-stat-data').mod('type', 'platform')(

    content()(function() {
        var statCtx = this.campStatCtx;

        return this.extend(applyNext(), {
            // передача в b-stat-table требуемых в runtime значений из campStatCtx
            js: u._.extend(
                u._.pick(statCtx, ['all', 'spec', 'directya', 'isInternalUser']), {
                    form: u._.pick(statCtx.form, ['target_all', 'target_0', 'target_1'])
                })
        });
    }),

    // DIRECT-43121 - в статистике "По площадкам" групировка только по дням
    elem('total-table-head').def()(function() {
        return applyNext({
            'campStatCtx.group': 'day'
        });
    }),

    elem('total-table-foot').def()(function() {
        var totalCellsLength = this.ctx.totalCellsLength,
            footer = applyNext(),
            campaign = this.campStatCtx.campaign,
            footerEl,
            metrikaRow,
            colsCount;

        footer.length == 0 && footer.push({ cols: [], elemMods: { 'border-bottom': 'no' } });
        footerEl = footer[0];

        if (campaign.metrika_counters) {
            metrikaRow = applyCtx({
                block: 'b-campaign-stat-data',
                elem: 'metrika-row',
                elemMod: this.ctx.mod,
                campaign: this.campStatCtx.campaign,
                noGroup: true
            });

            footerEl.cols.push(metrikaRow);
            colsCount = footerEl.cols.length;

            footerEl.cols[0].attrs.colspan = colsCount > 1 ? totalCellsLength - colsCount : totalCellsLength;
        }

        return footer;
    })
);
