block('b-campaign-stat-data')(

    def()(function() {
        var data = this.data,
            ctx = this.ctx,
            form = ctx.form,
            targets = [iget2('b-campaign-stat-data', 'vsego', 'всего'), iget2('b-campaign-stat-data', 'poisk', 'поиск'), iget2('b-campaign-stat-data', 'seti', 'сети')],
            choosenTargets = ['target_all', 'target_0', 'target_1'].reduce(function(result, item, i) {
                form[item] && result.push(targets[i]);
                return result;
            }, []);

        // создаём меморизированную функцию, для вызова в очень часто повторяющихся местах
        data.getMemoizedSortTableHeader = u._.memoize(
            u.table.getSortHeaderLink,
            function(args) {
                return args.col + args.caption;
            });

        // переопределяем на свой более простой кэш, так значительно быстрее
        data.getMemoizedSortTableHeader.cache = {
            data: {},

            set: function(key, value) {
                this.data[key] = value;
                return this;
            },

            get: function(key) {
                return this.data[key];
            },

            has: function(key) {
                return typeof this.data[key] !== 'undefined';
            }
        };

        !form.target_all && !form.target_0 && !form.target_1 &&
            (form.target_all = 1);

        this['price-or-ndash'] = function(val) {
            return val != undefined && !isNaN(val) ?
                u.numberFormatter.format(val, {
                    exponentDelimiter: '&nbsp;'
                }) :
                '&ndash;';
        };

        this['value-or-ndash'] = function(val) {
            return val != undefined && !isNaN(val) ? '' + val : '&ndash;';
        };

        this.formatStatDate = function(date, group) {
            if (group !== 'day') return date;

            // Это `u.moment(date, 'DD.MM.YYYY').format('ddd')` вызывает Segmentation fault :(
            // поэтому просто парсим сами и извлекаем день недели из списка moment
            var dateParts = date.split('.'),
                dateObj = new Date(+dateParts[2], +dateParts[1] - 1, +dateParts[0]);

            return date + ', ' + u.moment.weekdaysShort()[dateObj.getDay()];
        };

        return applyNext({
            targetsLength: choosenTargets.length || 1,
            currency: u.currencies.getName(ctx.campaign ? ctx.campaign.currency : data.work_currency),
            choosenTargets: choosenTargets.join('&nbsp;/&nbsp;'),
            targets: targets,
            needMetrika: ctx.tasesnum == 0 && ctx.sesnumForWeek == 0,
            campStatCtx: ctx
        });
    }),

    content()(function() {
        var mods = this.mods.type ? { type: this.mods.type } : {},
            totalTableData = applyCtx({
                block: 'b-campaign-stat-data',
                elem: 'total-table',
                elemMods: mods
            }),
            data = [
                { rows: totalTableData.rows },
                { tbodyMods: { type: 'space' } }
            ],
            totalCellsLength = totalTableData.totalCellsLength;

        return {
            block: 'b-stat-table',
            mods: mods,
            content: data.concat(applyCtx({
                block: 'b-campaign-stat-data',
                elem: 'detailed-table',
                elemMods: mods,
                totalCellsLength: totalCellsLength
            }))
        };
    }),

    elem('total-table-first-cell-colspan').def()(1),

    elem('total-table-foot-elem-name').def()('total-table-foot'),

    elem('table-parts').def()(function() {
        var elemMods = this.ctx.elemMods,
            statData = this.ctx.statData,
            rows = ['table-head', 'table-body', 'table-foot'].reduce(function(res, name, i) {
                var el = {
                    elem: name,
                    elemMods: elemMods,
                    statData: statData
                };

                !i && (el.cellsItems = this.ctx.cellsItems);

                el.firstCellColspan = this.ctx.firstCellColspan;

                res = res.concat(applyCtx(el));

                return res;
            }.bind(this), []);

        return rows;
    }),

    elem('table-title').wrap()(function() {
        var statCtx = this.campStatCtx,
            showChartsManager = this.ctx.statData.dates && this.ctx.statData.dates.length > 0;

        return {
            block: 'b-stat-table',
            elem: 'campaign-table-title',
            caption: iget2('b-campaign-stat-data', 'summarnye-dannye-po-kampanii', 'Суммарные данные по кампании'),
            statData: this.ctx.statData,
            //DIRECT-54001 пробрасываем currency для графиков статистики
            currency: this.ctx.currency,

            // для новых графиков DIRECT-59325
            chartsManager: showChartsManager && {
                cid: statCtx.cid,
                groupByDate: statCtx.group,
                withNds: statCtx.withNds,
                date: statCtx.date
            }
        };
    })
);
