block('b-campaign-state').mod('with', 'direct-warning').content()(function() {
    var data = this.data,
        pm = data.login_rights,
        campaign = data.campaign,
        strategy = campaign.strategy,

        // определяем где у нас автобюджет, на поиске или в сети
        autoStrategy = strategy[strategy.search.name.match('autobudget') ? 'search' : 'net'],
        currency = u.currencies.getName(campaign.currency, {
            isPseudo: data.usePseudoCurrency
        }),
        autoBudgetWarn = data.autobudget_warning,
        priceBorder = data.camp_price_border,
        isMcbanner = campaign.mediaType == 'mcbanner',
        items = [];

    if (!this.ctx.isEasy) {
        autoBudgetWarn && (autoStrategy.name == 'autobudget' || autoStrategy.name == 'autobudget_week_bundle') &&
            items.push({
                elem: 'warning',
                content: autoStrategy.name == 'autobudget' && autoBudgetWarn.autobudgetForecast > 0 ? [
                    autoStrategy.bid ?
                                iget2(
                                    'b-campaign-state',
                                    'vnimanie-soglasno-prognozu-maksimalnyy',
                                    'Внимание! Согласно прогнозу, максимальный недельный бюджет вашей кампании составляет'
                                ) :
                                iget2(
                                    'b-campaign-state',
                                    'vnimanie-soglasno-prognozu-pri',
                                    'Внимание! Согласно прогнозу, при максимальной ставке {foo}, максимальный недельный бюджет вашей кампании составляет',
                                    {
                                        foo: '&nbsp;' + autoStrategy.bid + '&nbsp;' + currency
                                    }
                                ),
                    '&nbsp;' + data.autobudgetForecast + '&nbsp;' + currency,
                    iget2(
                        'b-campaign-state',
                        'oznakomitsya-s-sovetami-kak',
                        'Ознакомиться с советами, как увеличить эффективность кампании, можно {link}.',
                        {
                            link: function(text) {
                                return {
                                    block: 'link',
                                    mix: [{
                                        block: 'b-campaign-state',
                                        elem: 'warn-link'
                                    }],
                                    url: u.getCommonHelpUrl('/direct-tooltips/add-keywords.xml'),
                                    target: '_blank',
                                    content: text
                                };
                            }(iget2('b-campaign-state', 'oznakomitsya-s-sovetami-kak-param-link', 'здесь')),

                            context: 'link - здесь'
                        }
                    )
                ] :

                    autoStrategy.name == 'autobudget_week_bundle' && autoBudgetWarn.autobudgetForecastClicks > 0 ? [
                        autoStrategy.bid ?
                                    iget2(
                                        'b-campaign-state',
                                        'vnimanie-soglasno-prognozu-nbsp',
                                        'Внимание! Согласно прогнозу,&nbsp;при максимальной ставке {foo}&nbsp;{bar},',
                                        {
                                            foo: autoStrategy.bid,
                                            bar: currency
                                        }
                                    ) :
                                    autoStrategy.avg_bid ?
                                        iget2(
                                            'b-campaign-state',
                                            'vnimanie-soglasno-prognozu-nbsp-124',
                                            'Внимание! Согласно прогнозу,&nbsp;при средней ставке {foo}&nbsp;{bar},',
                                            {
                                                foo: autoStrategy.avg_bid,
                                                bar: currency
                                            }
                                        ) :
                                        iget2('b-campaign-state', 'vnimanie-soglasno-prognozu-nbsp-125', 'Внимание! Согласно прогнозу,&nbsp;'),
                        iget2(
                            'b-campaign-state',
                            'maksimalno-chislo-klikov-kotoroe',
                            'максимально число кликов, которое может быть достигнуто - {foo}.',
                            {
                                foo: autoBudgetWarn.autobudgetForecastClicks
                            }
                        ),
                        iget2(
                            'b-campaign-state',
                            'oznakomitsya-s-sovetami-kak',
                            'Ознакомиться с советами, как увеличить эффективность кампании, можно {link}.',
                            {
                                link: function(text) {
                                    return {
                                        block: 'link',
                                        mix: [{
                                            block: 'b-campaign-state',
                                            elem: 'warn-link'
                                        }],
                                        url: u.getCommonHelpUrl('/direct-tooltips/add-keywords.xml'),
                                        target: '_blank',
                                        content: text
                                    };
                                }(iget2('b-campaign-state', 'oznakomitsya-s-sovetami-kak-param-link', 'здесь')),

                                context: 'link - здесь'
                            }
                        )
                    ] : iget2(
                        'b-campaign-state',
                        'vnimanie-soglasno-link-statistike',
                        'Внимание! Согласно {link} и прогнозу, по объявлениям этой кампании не будет ни одного клика.',
                        {
                            link: function(text) {
                                return {
                                    block: 'link',
                                    mix: [{
                                        block: 'b-campaign-state',
                                        elem: 'warn-link'
                                    }],
                                    url: u.formatUrl({
                                        protocol: 'https',
                                        host: 'wordstat.' + data.yandex_domain
                                    }),
                                    target: '_blank',
                                    content: text
                                };
                            }(iget2('b-campaign-state', 'vnimanie-soglasno-link-statistike-param-link', 'статистике запросов')),

                            context: 'link - статистике запросов'
                        }
                    )
            });

        !data.valid && items.push({
            elem: 'warning',
            content: [
                iget2('b-campaign-state', 'novyy-adres-email-ozhidaet', 'Новый адрес {email} ожидает подтверждения.', {
                    email: {
                        block: 'b-campaign-state',
                        elem: 'warning-strong',
                        content: this.data.email
                    }
                }),
                '&nbsp;',
                !data.allow_edit_camp || pm.media_control || {
                    block: 'link',
                    url: u.getUrl('ValidateEmail', {
                        cid: data.cid,
                        ulogin: data.user_login
                    }),
                    content: data.user_login ?
                        iget2('b-campaign-state', 'podtverdit-adres-klientu', 'Подтвердить адрес клиенту') : iget2('b-campaign-state', 'podtverdit-adres', 'Подтвердить адрес')
                }
            ]
        });

        data.statusModerate == 'Yes' && (data.statusPostModerate == 'New' || data.statusPostModerate == 'Yes') &&
            +data.sum == 0 && items.push({
                elem: 'warning',
                content: [
                    isMcbanner ?
                        iget2(
                            'b-campaign-state',
                            'vashi-bannery-nahodyatsya-na',
                            'Ваши баннеры находятся на модерации. Их показы начнутся после прохождения проверки и поступления оплаты за размещение.'
                        ) :
                        iget2(
                            'b-campaign-state',
                            'vashi-obyavleniya-nahodyatsya-na',
                            'Ваши объявления находятся на модерации. Их показы начнутся после прохождения проверки и поступления оплаты за размещение.'
                        ),
                    !u.consts('domains').tr && iget2(
                        'b-campaign-state',
                        'kak-tolko-moderator-primet',
                        'Как только модератор примет объявления к показам, вы сможете внести деньги на счёт любым из доступных в Яндекс.Директе {methods}. Оплатить размещение можно и не дожидаясь окончания проверки. В этом случае физическим лицам доступна только оплата Яндекс.Деньгами, а юридическим – безналичный расчет.',
                        {
                            methods: function(text) {
                                return {
                                    block: 'link',
                                    target: '_blank',
                                    url: u.getCommonHelpUrl('/direct/payments/payment-methods.xml'),
                                    content: text
                                };
                            }(iget2('b-campaign-state', 'kak-tolko-moderator-primet-param-methods', 'способов оплаты')),

                            context: 'methods - способов оплаты'
                        }
                    ),
                    !u.consts('domains').tr && {
                        block: 'b-help-link',
                        url: u.getHelpUrl('pay-before-moderated')
                    }
                ]
            });
    }

    return [applyNext(), items];
});
