block('b-campaign-state')(

    addJs()(function() {
        return {
            ulogin: this.data.user_login,
            campaign: this.data.campaign,
            live: false
        };
    }),

    match(function() {
        return u.campaign.isCpm(this.data.mediaType) && this.data.campaign.brand_survey_id;
    }).mix()(function() {
        return {
            mods: { 'has-brand-lift': 'yes' }
        };
    }),

    content()(function() {
        var data = this.data,
            officeNick = data.manager_info && (data.manager_info.office || {}).office_nick,
            userFio = u.escapeHTML(data.user_fio),
            userLogin = u.escapeHTML(data.user_login),
            federalPhone,
            anotherBlrPhone,
            MAX_PHRASE_LENGTH = u.consts('MAX_PHRASE_LENGTH'),
            MAX_WORD_LENGTH = u.consts('MAX_WORD_LENGTH'),
            oldRussianOffices = ['msk', 'spb', 'ekb', 'kazan', 'rostov', 'nsk'],
            newRussianOffices = ['vvo', 'krr', 'rtv', 'kuf', 'cek', 'ufa', 'voz', 'pee', 'tjm', 'kra'],
            isNewOffice = newRussianOffices.indexOf(officeNick) !== -1;

        if (officeNick) {
            if (oldRussianOffices.concat(newRussianOffices).indexOf(officeNick) != -1) {
                federalPhone = '8 800 250-96-39';
            } else if (['minsk', 'blr'].indexOf(officeNick) != -1) {
                federalPhone = '+7 (495) 739-37-77';
                anotherBlrPhone = '8 8200 073-00-52';
            } else if (['kiev', 'ukr'].indexOf(officeNick) != -1) {
                federalPhone = '0 800 60-48-61';
            }
        }

        if (!data.action) data.action = {};

        return [
            Boolean(+data.is_hide_old_show_camps) ||
            Boolean(+data.is_show_dna_by_default) ||
            Boolean(+data.features_enabled_for_client.show_aggregated_status_open_beta) ?
                {
                    block: 'b-ess-status',
                    mix: [{
                        block: 'b-campaign-state',
                        elem: 'ess-status'
                    }],
                    campaignId: data.campaign.cid,
                    campaignStartDate: u.moment(data.start_date),
                    campaignEndDate: u.moment(data.finish_time || data.campaign.finish_time)
                } :
                {
                    block: 'icon-text',
                    mods: {
                        theme: 'info',
                        size: 'ms'
                    },
                    text: {
                        block: 'b-campaign-state',
                        elem: 'status',
                        content: [
                            {
                                elem: 'status-print',
                                content: iget2('b-campaign-state', 'status', 'Статус') + ':&nbsp;'
                            },
                            {
                                elem: 'status-text',
                                content: this.ctx.statusText
                            }
                        ]
                    }
                },
            {
                elem: 'status-description',
                content: [
                    data.campaign.type != 'cpm_price' && (data.action.resumeCamp || data.action.stopCamp) && {
                        block: 'button',
                        mix: [{
                            block: 'b-campaign-state',
                            elem: 'stop-resume-show',
                            elemMods: {
                                state: data.action.resumeCamp ? 'resume' : 'stop'
                            }
                        }],
                        content: data.action.resumeCamp ?
                            iget2('b-campaign-state', 'vozobnovit-pokazy', 'Возобновить показы') :
                            iget2('b-campaign-state', 'ostanovit-pokazy', 'Остановить показы')
                    },
                    !!data.campaign.hasOversizedBanners && {
                        elem: 'status-text',
                        content: u.pluralForms(iget2(
                            'b-campaign-state',
                            'v-kampanii-est-gruppy',
                            'В кампании есть группы, в которых число ключевых фраз превышает допустимое количество в {foo} {фразу|фразы|фраз} на группу. Рекомендуем разделить группы на несколько. Пока ошибка не будет исправлена, с кампанией нельзя будет работать через XLS/XLSX-файлы, Коммандер, API.',
                            {
                                foo: data.MAX_KEYWORD_LIMIT
                            }
                        ), data.MAX_KEYWORD_LIMIT)
                    },
                    !!data.campaign.hasOversizedPhrases && {
                        elem: 'status-text',
                        content: u.pluralForms(iget2(
                            'b-campaign-state',
                            'v-kampanii-est-klyuchevye',
                            'В кампании есть ключевые фразы, длина которых превышает допустимую длину в {foo} {символ|символа|символов}. Рекомендуем сократить фразы. Пока ошибка не будет исправлена, с кампанией нельзя будет работать через XLS/XLSX-файлы, Коммандер, API.',
                            {
                                foo: MAX_PHRASE_LENGTH
                            }
                        ), MAX_PHRASE_LENGTH)
                    },
                    !!data.campaign.hasOversizedPhraseWordCount && {
                        elem: 'status-text',
                        content: iget2(
                            'b-campaign-state',
                            'v-kampanii-est-gruppy-120',
                            'В кампании есть группы, в которых количество слов в ключевой фразе превышает ограничение в 7 слов. Рекомендуем сократить количество слов. Пока ошибка не будет исправлена, с кампанией нельзя будет работать через XLS/XLSX-файлы, Коммандер, API.'
                        )
                    },
                    !!data.campaign.hasOversizedPhraseWordLength && {
                        elem: 'status-text',
                        content: u.pluralForms(iget2(
                            'b-campaign-state',
                            'v-kampanii-est-klyuchevye-121',
                            'В кампании есть ключевые фразы, длина слов в которых превышает допустимую длину в {foo} {символ|символа|символов} для одного слова. Пока ошибка не будет исправлена, с кампанией нельзя будет работать через XLS/XLSX-файлы, Коммандер, API.',
                            {
                                foo: MAX_WORD_LENGTH
                            }
                        ), MAX_WORD_LENGTH)
                    },
                    !!data.campaign.hasOversizedPhraseMinusWordLength && {
                        elem: 'status-text',
                        content: u.pluralForms(iget2(
                            'b-campaign-state',
                            'v-kampanii-est-minus',
                            'В кампании есть минус-слова, длина которых превышает допустимую длину в {foo} {символ|символа|символов} для одного слова. Пока ошибка не будет исправлена, с кампанией нельзя будет работать через XLS/XLSX-файлы, Коммандер, API.',
                            {
                                foo: MAX_WORD_LENGTH
                            }
                        ), MAX_WORD_LENGTH)
                    },
                    !!data.campaign.can_be_autodeleted && {
                        elem: 'delete-warning-text',
                        content: this.ctx.isEasy ?
                            iget2(
                                'b-campaign-state',
                                'obratite-vnimanie-reklamnye-obyavleniya',
                                'Обратите внимание: рекламные объявления, не начавшие размещение в течение года после создания, будут удалены.'
                            ) : iget2(
                                'b-campaign-state',
                                'obratite-vnimanie-reklamnye-kampanii',
                                'Обратите внимание: рекламные кампании, не начавшие размещение в течение года после создания, будут удалены.'
                            )
                    }
                ]
            },
            u.campaign.isCpm(data.campaign.mediaType) && data.campaign.strategy2 &&
                u.strategy.isExpiredCpmPeriod(data.campaign.strategy2.options.net.finish) && {
                    block: 'icon-text',
                    mods: { theme: 'alert', size: 'ms' },
                    mix: [{ block: 'b-campaign-state', elem: 'delete-warning-text' }],
                    text: iget2('b-campaign-state', 'strategy-warning-not-relevant-period', 'Период настройки стратегии неактуален')
                },

            this.ctx.needClientInfo && {
                elem: 'client-info',
                content: [
                    iget2('b-campaign-state', 'klient-122', 'Клиент:'),
                    userFio,
                    userFio != userLogin ? '(' + userLogin + ')' : ''
                ].join(' ')
            },
            !!data.agency_uid && data.agency_info && ({
                block: 'b-agency-contacts',
                agencyContacts: data.campaign_agency_contacts
            }),
            !!data.manager_uid && data.manager_info && {
                elem: 'manager-info',
                info: data.manager_info,
                federalPhone: federalPhone,
                isNewOffice: isNewOffice,
                anotherBlrPhone: anotherBlrPhone
            },
            this.ctx.lowConversionsWarning && {
                block: 'b-low-conversions-warning',
                mix: {
                    block: 'b-campaign-info',
                    elem: 'low-conversions-warning',
                    elemMods: {
                        hidden: 'yes'
                    }
                }
            }
        ];
    }),

    elem('manager-info').content()(function() {
        var addPhone = parseInt(u.escapeHTML(this.ctx.info.phone) || '');

        return [
            iget2('b-campaign-state', 'menedzher-123', 'Менеджер:'),
            '&nbsp;',
            {
                block: 'link',
                url: 'mailto:' + this.ctx.info.email,
                content: this.ctx.info.fio
            },
            {
                elem: 'manager-phone',
                attrs: {
                    title: iget2('b-campaign-state', 'dobavochnyy-telefon', 'Добавочный телефон')
                },
                content: [
                    this.ctx.federalPhone && {
                        block: 'b-phone-number-parser',
                        mix: [{
                            block: 'b-campaign-state',
                            elem: 'federal-phone'
                        }],
                        content: this.ctx.federalPhone
                    },
                    this.ctx.anotherBlrPhone && {
                        block: 'b-phone-number-parser',
                        mix: [{
                            block: 'b-campaign-state',
                            elem: 'federal-phone'
                        }],
                        content: this.ctx.anotherBlrPhone
                    },
                    !this.ctx.isNewOffice && this.ctx.info.office && !this.ctx.anotherBlrPhone && {
                        block: 'b-phone-number-parser',
                        content: this.ctx.info.office.office_phone
                    },
                    !!addPhone && addPhone.toString().length <= 5 && {
                        elem: 'additional-phone',
                        content: (iget2('b-campaign-state', 'dob', 'доб.') + '&nbsp;' + addPhone)
                    }
                ]
            }
        ];
    })
);
