BEM.DOM.decl('b-campaign-state', {

    onSetMod: {
        js: function() {
            this.campaignId = this.params.campaign.cid;
        }
    },

    _onStopResumeClick: function(e) {
        var stopResume = e.block,
            isResume = this.getMod(this.elem('stop-resume-show'), 'state') === 'resume',
            essStatusBlock = this.findBlockOn('ess-status', 'b-ess-status');

        BEM.blocks['b-metrika2'].params({
            params: {
                showCamp: {
                    'stop-resume': isResume ? 'resume' : 'stop'
                }
            }
        });

        stopResume.setMod('disabled', 'yes'); // на время запроса дизейблим

        BEM.create('i-request_type_ajax', {
            type: 'post',
            url: '/registered/main.pl',
            dataType: 'json'
        }).get(
            {
                ulogin: u.consts('ulogin'),
                cid: this.campaignId,
                cmd: 'ajaxStopResumeCamp',
                do_stop: +!isResume //0
            },
            function(data) {
                if (data.error) {
                    BEM.blocks['b-confirm'].alert(data.error);

                    return;
                }

                stopResume
                    .delMod('disabled')
                    .setText(
                        isResume ?
                            iget2('b-campaign-state', 'ostanovit-pokazy', 'Остановить показы') :
                            iget2('b-campaign-state', 'vozobnovit-pokazy', 'Возобновить показы')
                    );

                this.setMod(this.elem('stop-resume-show'), 'state', isResume ? 'stop' : 'resume');

                this.channel('campState').trigger('change', { state: isResume ? 'on' : 'off' });

                BEM.DOM.update(this.elem('status-text'), data.status);

                if (essStatusBlock) {
                    essStatusBlock.updateStatus();
                }
            }.bind(this),
            function() {
                BEM.blocks['b-confirm']
                    .alert(iget2('b-campaign-state', 'oshibka-soedineniya', 'Ошибка соединения!'));

                stopResume.delMod('disabled', 'yes');
            }.bind(this)
        );
    },

    _onButtonClick: function(e) {
        if (this.elem('stop-resume-show').is(e.block.domElem)) {
            this._onStopResumeClick(e);
        }
    }
}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button', function(e, data) {
            this._onButtonClick(e, data);
        });
    }

});
