block('b-campaign-strategy2').elem('hint-forecast')(
    match(function() {
        return this.ctx.dataForecast;
    }).content()(function() {
        var ctx = this.ctx,
            dataForecast = ctx.dataForecast,
            errorCode = dataForecast.errorCode,
            requestID = dataForecast.hint && dataForecast.hint.id,
            forecastTextContent,
            hintPopupTextContent;

        switch (dataForecast.color) {
            case 'green':
                forecastTextContent = iget2('b-strategy2-settings', 'forecast-good', 'Установлена оптимальная цена');
                hintPopupTextContent = iget2('b-strategy2-settings', 'forecast-good', 'Установлена оптимальная цена');
                break;

            case 'yellow':
                forecastTextContent = iget2('b-campaign-strategy2', 'hint-forecast-warning', 'Увеличьте цену, чтобы получить больше показов за период в рамках заданного бюджета');
                hintPopupTextContent = iget2('b-strategy2-settings', 'forecast-help-warning', 'Откройте настройки стратегии, чтобы установить оптимальную цену и получить больше показов');
                break;

            case 'red':
                forecastTextContent = iget2('b-campaign-strategy2', 'hint-forecast-warning', 'Увеличьте цену, чтобы получить больше показов за период в рамках заданного бюджета');
                hintPopupTextContent = iget2('b-strategy2-settings', 'forecast-help-warning', 'Откройте настройки стратегии, чтобы установить оптимальную цену и получить больше показов');
                break;

            case 'grey':
                if (errorCode) {
                    forecastTextContent = iget2('b-strategy2-settings','forecast-construction-error', 'Не удалось построить прогноз');

                    if (dataForecast.errorCode === 'InventoriDefectIds.Gen.NO_SUITABLE_ADGROUPS') {
                        hintPopupTextContent = this.ctx.campaignType === 'cpm_yndx_frontpage' ?
                            iget2('b-strategy2-settings', 'forecast-help-groups-frontpage', 'Добавьте активные группы') :
                            iget2('b-strategy2-settings', 'forecast-help-groups', 'Добавьте активные группы с условием показа по профилю пользователя');
                    }
                } else {
                    forecastTextContent = iget2('b-strategy2-settings', 'loading', 'загрузка{ellipsis}', { ellipsis: '...' });
                }
                break;
        }

        return [
            {
                elem: 'simple-forecast',
                elemMods: {
                    color: dataForecast.color
                }
            },
            {
                elem: 'simple-forecast-text',
                tag: 'span',
                content: [
                    forecastTextContent,
                    hintPopupTextContent && {
                        block: 'b-help-link',
                        mix: [
                            {
                                block: 'b-hintable-popup',
                                js: {
                                    hint: {
                                        block: 'b-campaign-strategy2',
                                        elem: 'cpm-forecast-popup-hint',
                                        content: [
                                            requestID && {
                                                elem: 'cpm-forecast-popup-title',
                                                content: iget2('b-strategy2-settings', 'forecast-help-id', 'ID прогноза: {requestId}', { requestId: requestID })
                                            },
                                            {
                                                elem: 'cpm-forecast-popup-content',
                                                content: hintPopupTextContent,
                                            }
                                        ]
                                    },
                                    directions: ['bottom'],
                                    onScroll: 'close'
                                }
                            },
                            {
                                block: 'b-campaign-strategy2',
                                elem: 'cpm-forecast-popup-link'
                            }
                        ]
                    }
                ]
            }
        ];
    }),

    match(function() {
        return this.ctx.isStrategyExpired && !this.ctx.isCampaignPage;
    }).content()(function() {
        return [
            {
                elem: 'hint-warning',
                content: iget2('b-campaign-strategy2', 'strategy-warning-not-relevant-period', 'Период настройки стратегии неактуален, замените его на новый'),
            }
        ]
    })
);
