block('b-campaign-strategy2').elem('study-strategy-status').content()(function() {
    var status = this.ctx.status;

    if (!status) {
        return;
    }

    var title,
        info;

    switch (status) {
        case 'LEARNED':
            title = iget2('b-campaign-strategy2', 'learned-strategy-type-title', 'Стратегия обучилась');
            info = iget2('b-campaign-strategy2', 'learned-strategy-type-info', 'Не изменяйте настройки без необходимости');
            break;

        case 'LEARNING':
            title = iget2('b-campaign-strategy2', 'learning-strategy-type-title', 'Идет обучение стратегии и сбор статистики');
            info = iget2('b-campaign-strategy2', 'learning-strategy-type-info', 'Не меняйте настройки');
            break;

        case 'NOT_LEARNED':
            title = iget2('b-campaign-strategy2', 'not-learned-strategy-type-title', 'Обучение стратегии не идет');

            return [
                {
                    elem: 'study-strategy-status-title',
                    tag: 'span',
                    content: title
                },
                {
                    block: 'b-help-link',
                    mods: { type: 'modal' },
                    mix: [{ block: 'b-campaign-strategy2', elem: 'study-strategy-status-help-icon' }],
                    icon: {
                        'size-13': 'alert-question'
                    },
                    url: u.getHelpUrl('conversions-few')
                }
            ]

        default:
            return;
    }

    return [
        {
            elem: 'study-strategy-status-title',
            tag: 'span',
            content: title + '.'
        },
        {
            elem: 'study-strategy-status-info',
            tag: 'span',
            content: info
        }
    ]
});
