BEM.DOM.decl({ block: 'b-campaign-strategy2', modName: 'campaign-type', modVal: 'cpm-banner' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            /**
             * Подписка на изменение корректировок ставок и частоты показов в модели
             */
            this._subMan.wrap(this._campaignModel)
                .on('rfReset rf multipliersPct', 'change', $.debounce(this._updateForecast, 150, this), this);

            this._campaignModel.getChildGroupsByIds(this._campaignModel.get('allAdgroupIds')).forEach(function(groupModel) {
                this._subMan.wrap(groupModel)
                    .on('banners_quantity', 'change', $.debounce(this._updateForecast, 150, this), this);
            }.bind(this));
        }
    },

    _dataForecastDefault: {
        color: 'grey'
    },

    /**
     * Сохранение данных: апдейт модели стратегии в кампании
     * И перезаписываем данные дневного бюджета
     * @param {Object} data - данные для сохранения
     * @private
     */
    _doSave: function(data) {
        this.__base.apply(this, arguments);
        // для страницы кампании и создание новой кампании
        BEM.blocks['b-metrika2'].reachGoal('CPM_STRATEGY_SAVED');
    },

    /**
     * Добавляет в данные стратегии поле strategyCmpAutoCoverage это нужно  для сохранения типа охвата
     * @returns {{settingsJSON: *, dayBudgetSettingsJSON: *, title: *,
     *      strategyOptionsHint: String, dayBudgetEnabled: (boolean|*), dayBudgetOptionsHint: string,
     *      strategyCmpAutoCoverage: string}}
     * @private
     */
    _getViewModelData: function() {
        var baseStrategy = this.__base.apply(this, arguments),
            strategyData = this._campaignModel.get('strategy2').toJSON();

        this._coverageWeekModeFromServer = this._campaignModel.get('strategy_cpm_auto_coverage');

        return Object.assign({}, baseStrategy, {
            strategyCmpAutoCoverage: this._getCoverageWeekMode(strategyData)
        });
    },

    /**
     *
     * @param {String} strategy - текущие настройки стратегии
     * @returns {String} - значение типа охвата для недельной стратегии мультимедийной кампании (wide | narrow)
     */
    _getCoverageWeekMode: function(strategy) {
        return (strategy.options.net && strategy.options.net.coverageWeekMode) || this._coverageWeekModeFromServer;
    },

    /**
     * В случае автостратегии показывает светофор превью прогноза
     * @param {Object} options - опции
     * @returns {Array}
     * @private
     */
    _getStrategyHint: function(options) {
        this._updateForecast();
        return this.__base.apply(this, arguments);
    },

    /**
     * Получение светофора превью прогноза
     * @private
     */
    _updateForecast: function() {
        var cid = this._campaignModel.get('cid'),
            isArchived = this._campaignModel.get('archived') === 'Yes',
            strategy2 = this._campaignModel.get('strategy2'),
            isAutoStrategy = cid && strategy2.get('is_autobudget'),
            _this = this,
            requestParams = u['b-campaign-strategy2']._getHintForecastParams(this._campaignModel),
            isFirstLoad = !requestParams.strategy.budget && !requestParams.strategy.sum,
            strategyFinishDate = strategy2.toJSON().options.net.finish,
            isPeriodExpired = Date.now() > Number(new Date(strategyFinishDate)),
            groupsIDs = this._campaignModel.get('allAdgroupIds'),
            isCampaignPage = this.hasMod('on-page', 'campaign');

        if (isPeriodExpired) {
            this._showStrategyExpiredError(isCampaignPage);
        }

        // Делаем запрос в превью прогноза
        if (isAutoStrategy && !isArchived) {
            if (!isFirstLoad && !isPeriodExpired) {
                this._updateForecastInDom();

                // Информация о группах есть только на странице кампании
                // в остальных случаях делаем запрос
                if (groupsIDs.length === 0 && isCampaignPage) {
                    this._updateForecastInDom({
                        color: 'grey',
                        errorCode: 'InventoriDefectIds.Gen.NO_SUITABLE_ADGROUPS'
                    });
                } else {
                    this.setMod(this.findElem('simple-forecast'), 'loading', 'yes');
                    u['b-campaign-strategy2']._getHintForecast(requestParams)
                        .then(function(data) {
                            _this._updateForecastInDom(data);
                        })
                        .catch(function(err) {
                            // TODO: Передать request_id в туллтип при ошибке.
                            _this._updateForecastInDom({
                                color: 'grey',
                                errorCode: 'unknown'
                            });
                        });
                }
            }
        } else {
            this._hideForecastHint();
        }
    },

    /**
     * Показывает сообщение об неактуальном периоде настройки стратегии
     * @private
     * @param {Boolean} isCampaignPage - флаг, показывающий отрендерен ли блок на странице кампании.
     */
    _showStrategyExpiredError: function(isCampaignPage) {
        this._hintForecastReplace({
            isStrategyExpired: true,
            isCampaignPage: isCampaignPage,
        });
    },

    /**
     * Скрывает светофор превью прогноза
     * @private
     */
    _hideForecastHint: function() {
        this._hintForecastReplace({});
    },

    /**
     * Перестраивает светофор в DOM на основе переданных параметров
     * @param {Object} dataForecast - данные построенного прогноза
     * @param {String} dataForecast.color - цвет светофора прогноза
     * @param {Object} dataForecast.hint - данные прогноза для туллтипа
     * @param {String} dataForecast.hint.id - id прогноза (request_id)
     * @param {String} dataForecast.errorCode - код ошибки создания прогноза
     * @private
     */
    _updateForecastInDom: function(dataForecast) {
        dataForecast = dataForecast || this._dataForecastDefault;

        this._hintForecastReplace({
            dataForecast: dataForecast
        });
    },

    /**
     * Находит в DOM hint-forecast и рендерит на его месте новый блок на основе опций.
     * @param {Object} options — опции рендеринга блока светофора.
     * @param {Object} options.dataForecast — данные построенного прогноза.
     * @param {Boolean} options.isForecastExist — флаг существования прогноза.
     * @param {Object} options.hintForecastPopupContent — контент для попапа подсказки.
     * @param {Boolean} options.isStrategyExpired — флаг, показывающий истек ли срок стратегии.
     * @param {Boolean} options.isCampaignPage — флаг, показывающий отрендерен ли блок на странице кампании.
     * @private
     */
    _hintForecastReplace: function(options) {
        options.block = 'b-campaign-strategy2';
        options.elem = 'hint-forecast';
        options.campaignType = this.params.campaignType;

        BEM.DOM.replace(this.findElem('hint-forecast'), BEMHTML.apply(options));
    }
});
