BEM.DOM.decl({ block: 'b-campaign-strategy2', modName: 'campaign-type', modVal: 'cpm-yndx-frontpage' }, {

    /**
     * Код вынесен из JS секции для переопределения
     * @private
     */
    _initSwitcher: function() {
        this._subMan.on(this._switcher, 'click', function() {
            this._getMinPriceByGeo().then(function(minPrice) {
                var selectedFrontpageTypes = this._campaignModel.get('allowed_frontpage_types'),
                    frontpageType;

                if (typeof selectedFrontpageTypes === 'string') {
                    selectedFrontpageTypes = JSON.parse(selectedFrontpageTypes);
                }

                // Преобразовываем и передаем выбранные версии морды для запроса в прогнозатор
                frontpageType = u._.flatten(
                    selectedFrontpageTypes.map(function(type) { return u.campaign.frontpageTypeToForecastFormat(type) })
                );

                this._switcher.domElem.blur();
                this._initPopup(
                    this._campaignModel.get('strategy2').toJSON(),
                    this._campaignModel.get('day_budget2').toJSON(),
                    {
                        start: this._campaignModel.get('start_date'),
                        finish: this._campaignModel.get('finish_date')
                    },
                    minPrice,
                    frontpageType
                );
            }.bind(this));

        }, this);

        /**
         * Подписка на изменение частоты показов в модели
         */
        this._subMan.wrap(this._campaignModel)
            .on('rfReset rf allowed_frontpage_types', 'change', $.debounce(this._updateForecast, 150, this), this);

        this._campaignModel.getChildGroupsByIds(this._campaignModel.get('allAdgroupIds')).forEach(function(groupModel) {
            this._subMan.wrap(groupModel)
                .on('banners_quantity', 'change', $.debounce(this._updateForecast, 150, this), this);
        }.bind(this));
    },

    _dataForecastDefault: {
        color: 'grey'
    },

    /**
     * Инициализация попапа стратегий
     * @param {Object} strategyData - данные модели стратегий
     * @param {Object} dayBudgetData - данные модели дневного бюджета
     * @param {Object} campaignPeriod
     * @param {Number} minAutobudgetAvgCpm
     * @param {String} frontpageType
     * @private
     */
    _initPopup: function(strategyData, dayBudgetData, campaignPeriod, minAutobudgetAvgCpm, frontpageType) {
        if (this._popup && this._popup.isShown()) return;

        // всегда создаем попап заново
        this._popup = BEM.DOM.blocks['b-modal-popup-decorator'].create2(undefined, { bodyScroll: false }, $);
        // чтобы блоки с live-инициализацией и i-glue модели корректно отрабатывали,
        // надо, чтобы все блоки добавлялись в dom сразу
        this._popup.show();

        var disablePlatformChange = ['cpm_banner', 'cpm_deals', 'mcbanner', 'cpm_yndx_frontpage'];

        this._strategyChoose = this._popup.setPopupContent(
            {
                block: 'b-campaign-strategy2-decorator',
                mods: { type: this.getMod('campaign-type') || 'default' },
                campaignPeriod: campaignPeriod,
                strategies: this.params.strategies,
                dayBudgetSettings: this._mapToDayBudget2Data(this.params.dayBudgetSettings, dayBudgetData),
                strategyModel: this._mapCampaignDataToChooseData(strategyData),
                disablePlatformChange: u._.contains(disablePlatformChange, this._mediaType),
                walletInfo: this.params.walletInfo,
                minAutobudgetAvgCpm: minAutobudgetAvgCpm,
                frontpageType: frontpageType,
                isChangeManualStrategyName: this.params.isChangeManualStrategyName,
                isSavedPeriodStrategyEditable: this.params.isSavedPeriodStrategyEditable
            }).getChooser();

        this._strategyChoose.setDayBudgetEvent(this._onDayBudgetChange.bind(this));
        this._initEvents();
    },

    _getMinPriceByGeo: function() {
        var deferred = $.Deferred(),
            campaignModel = this._campaignModel,
            getAdGroupsData = this._isShowCampPage(),
            cid = campaignModel.get('cid'),
            campaignGeoModel = BEM.MODEL.getOne('m-geo-regions');

        // Если у нас нет cid'a и модели ГЕО
        // Значит что-то идет не так или мы просто на создании кампании
        // Тогда мы берем дефолтную ставку для MIN_CPM_FRONTPAGE_PRICE
        if (!cid && (!campaignGeoModel || !campaignGeoModel.get('geo'))) {
            deferred.resolve(u.currencies.getConst(campaignModel.get('currency'), 'MIN_CPM_FRONTPAGE_PRICE'));
        } else {
            this._getChangedAdGroupGeo(
                cid,
                campaignGeoModel && campaignGeoModel.get('geoChangesJson')
            ).then(function(ajaxResp) {
                var frontpageTypes = campaignModel.get('allowed_frontpage_types'),
                    params = {
                        campaign_geo: campaignGeoModel ? campaignGeoModel.get('geo') : campaignModel.get('geo'),
                        validate_campaign: true,
                        get_adgroups_data: getAdGroupsData,
                        strategy_auto_price: 0,
                        frontpage_warnings_get_items: ajaxResp.adgroups || []
                    };

                if (typeof frontpageTypes === 'string') {
                    frontpageTypes = JSON.parse(frontpageTypes);
                }

                if (cid) {
                    params.campaign_id = cid;
                }

                if (frontpageTypes.join(',').length) {
                    params.allowed_frontpage_type = frontpageTypes.join(',');
                }

                BEM.blocks['i-web-api-request'].cpmYndxFrontpage.getFrontpagePriceWarnings(
                    u.consts('ulogin'),
                    params
                ).then(function(javaResp) {
                    deferred.resolve(javaResp.min_price);
                });
            });
        }

        return deferred.promise();
    },

    _getChangedAdGroupGeo: function(cid, geoChangesJson) {
        var deferred = $.Deferred(),
            request;

        // при пустых изменениях или во время создания кампании ходить на сервер за гео-групп не нужно
        if (!!cid && geoChangesJson && geoChangesJson !== '{}') {
            request = BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                type: 'POST',
                cache: false,
                dataType: 'json',
                callbackCtx: this
            });

            request.get(
                { cmd: 'ajaxGetChangedAdGroupGeo', cid: cid, json_geo_changes: geoChangesJson },
                function(response) {
                    if (response.errors || !response.ok) {
                        deferred.rejectWith(this, [response]);
                    } else if (response.ok) {
                        deferred.resolveWith(this, [response]);
                    }
                },
                function(response) {
                    deferred.rejectWith(this, [response]);
                },
                { callbackCtx: this, timeout: 60000 });
        } else {
            deferred.resolveWith(this, [{}]);
        }

        return deferred.promise();
    },

    /**
     * Проверяем что находимя в текущий момент на стр. просмотра кампании
     * @returns {boolean}
     * @private
     */
    _isShowCampPage: function() {
        return this._campaignModel.get('currentTab') !== '';
    },

    /**
     * Сохранение данных: апдейт модели стратегии в кампании
     * И перезаписываем данные дневного бюджета
     * @param {Object} data - данные для сохранения
     * @private
     */
    _doSave: function(data) {
        this.__base.apply(this, arguments);
        // для страницы кампании и создание новой кампании
        BEM.blocks['b-metrika2'].reachGoal('CPM_STRATEGY_SAVED');
    },

    /**
     * В случае автостратегии показывает светофор превью прогноза
     * @param {Object} options - опции
     * @returns {Array}
     * @private
     */
    _getStrategyHint: function(options) {
        this._updateForecast();
        return this.__base.apply(this, arguments);
    },

    /**
     * Получение светофора превью прогноза
     * @private
     */
    _updateForecast: function() {
        var cid = this._campaignModel.get('cid'),
            isArchived = this._campaignModel.get('archived') === 'Yes',
            strategy2 = this._campaignModel.get('strategy2'),
            isAutoStrategy = cid && strategy2.get('is_autobudget'),
            _this = this,
            requestParams = u['b-campaign-strategy2']._getHintForecastParams(this._campaignModel),
            isFirstLoad = !requestParams.strategy.budget && !requestParams.strategy.sum,
            strategyFinishDate = strategy2.toJSON().options.net.finish,
            isPeriodExpired = Date.now() > Number(new Date(strategyFinishDate)),
            groupsIDs = this._campaignModel.get('allAdgroupIds'),
            isCampaignPage = this.hasMod('on-page', 'campaign');

        if (isPeriodExpired) {
            this._showStrategyExpiredError(isCampaignPage);
        }

        // Делаем запрос в превью прогноза
        if (isAutoStrategy && !isArchived) {
            if (!isFirstLoad && !isPeriodExpired) {
                this._updateForecastInDom();

                // Информация о группах есть только на странице кампании
                // в остальных случаях делаем запрос
                if (groupsIDs.length === 0 && isCampaignPage) {
                    this._updateForecastInDom({
                        color: 'grey',
                        errorCode: 'InventoriDefectIds.Gen.NO_SUITABLE_ADGROUPS'
                    });
                } else {
                    this.setMod(this.findElem('simple-forecast'), 'loading', 'yes');
                    u['b-campaign-strategy2']._getHintForecast(requestParams)
                        .then(function(data) {
                            _this._updateForecastInDom(data);
                        })
                        .catch(function(err) {
                            // TODO: Передать request_id в туллтип при ошибке.
                            _this._updateForecastInDom({
                                color: 'grey',
                                errorCode: 'unknown'
                            });
                        });
                }
            }
        } else {
            this._hideForecastHint();
        }
    },

    /**
     * Скрывает светофор превью прогноза
     * @private
     */
    _hideForecastHint: function() {
        this._hintForecastReplace({});
    },

    /**
     * Перестраивает светофор в DOM на основе переданных параметров
     * @param {Object} dataForecast - данные построенного прогноза
     * @param {String} dataForecast.color - цвет светофора прогноза
     * @param {Object} dataForecast.hint - данные прогноза для туллтипа
     * @param {String} dataForecast.hint.id - id прогноза (request_id)
     * @param {String} dataForecast.errorCode - код ошибки создания прогноза
     * @private
     */
    _updateForecastInDom: function(dataForecast) {
        dataForecast = dataForecast || this._dataForecastDefault;

        this._hintForecastReplace({
            dataForecast: dataForecast
        });
    },

    /**
     * Находит в DOM hint-forecast и рендерит на его месте новый блок на основе опций.
     * @param {Object} options — опции рендеринга блока светофора.
     * @param {Object} options.dataForecast — данные построенного прогноза.
     * @param {Boolean} options.isForecastExist — флаг существования прогноза.
     * @param {Object} options.hintForecastPopupContent — контент для попапа подсказки.
     * @param {Boolean} options.isStrategyExpired — флаг, показывающий истек ли срок стратегии.
     * @param {Boolean} options.isCampaignPage — флаг, показывающий отрендерен ли блок на странице кампании.
     * @private
     */
    _hintForecastReplace: function(options) {
        options.block = 'b-campaign-strategy2';
        options.elem = 'hint-forecast';
        options.campaignType = this.params.campaignType;

        BEM.DOM.replace(this.findElem('hint-forecast'), BEMHTML.apply(options));
    }

});
