BEM.DOM.decl({ block: 'b-campaign-strategy2', modName: 'campaign-type', modVal: 'mobile-content' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            if (this._isNeedPresetting()) {
                this._initPresettingBlock();
                this.setMod('has-presetting', 'yes');

                this._subMan.wrap(this._presetting)
                    .on('update', function(e, data) {
                        this._doSave(data, true);
                    }, this);
            }

        }
    },

    _isNeedPresetting: function() {
        var strategy = this._campaignModel.get('strategy2').toJSON(),
            isCPIPresettingMatch = strategy.name === 'autobudget_avg_cpi' && !strategy.options.bid && !strategy.options.sum,
            isClickPresettingMatch = strategy.name === 'autobudget_avg_click' && !strategy.options.sum;

        return (isCPIPresettingMatch || isClickPresettingMatch) && this._campaignModel.get('new_camp');
    },

    /**
     * Включает/отключает возможность выбора стратегии CPI
     * @param {Boolean} isAllowed
     */
    allowAvgCPI: function(isAllowed) {

        if (!this._presetting) {
            return;
        }

        if (!isAllowed) {
            if (this._campaignModel.get('strategy2').get('name') === 'autobudget_avg_cpi') {
                this.setMod('has-presetting', 'yes');
                this._presetting.setSelected('avg-click');
            }
            this._presetting.setDisabledStrategies(['avg-cpi']);
        } else {
            this._presetting.setDisabledStrategies([]);
        }
    },

    /**
     * Инициализирует блок преднастроек
     * @return {*|BEM}
     * @private
     */
    _initPresettingBlock: function() {

        if (!this._presetting) {
            BEM.DOM.update(this.elem('presetting'), BEMHTML.apply({
                block: 'b-mobile-strategy-presetting',
                strategy: this._campaignModel.get('strategy2').toJSON(),
                campaignData: {
                    rmpCounters: this._campaignModel.get('rmpCounters')
                },
                currency: this._campaignModel.get('currency')
            }));

            if (!this._campaignModel.get('selected_mobile_app') && this.elem('strategy-warning').length) {
                this._setStrategyWarningVisible('yes');

                this._subMan.on(this._campaignModel, 'selected_mobile_app', 'change', function() {
                    this._setStrategyWarningVisible('');
                }, this);

                this.setMod(this.elem('presetting'), 'hidden', 'yes');
            }

            this._presetting = this.findBlockInside(this.elem('presetting'), 'b-mobile-strategy-presetting');
        }

        return this._presetting;
    },

    /**
     * Проверяет валидный ли блок, если он используется
     * @return {*}
     */
    isValid: function() {
        if (this.hasMod('has-presetting', 'yes')) {
            return this._presetting.isValid();
        }

        return true;
    },

    /**
     * Сохранение данных: апдейт модели стратегии в кампании
     * И перезаписываем данные дневного бюджета
     * @param {Object} data - данные для сохранения
     * @param {Boolean} keepPresetting - выключить панель или нет
     * @private
     */
    _doSave: function(data, keepPresetting) {
        this.__base.apply(this, arguments);

        keepPresetting || this.delMod('has-presetting');
    }

});
