/**
 * Блок настройки стратегии с сохранением данных на бэкенд
 * @fires ready-to-save – событие клика по кнопке Сохранить
 */
BEM.DOM.decl({ block: 'b-campaign-strategy2', modName: 'with-ajax-save', modVal: 'yes' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._script = this.params.script;
            this._ulogin = this.params.ulogin;
            this._cid = this._campaignModel.get('cid');
        }
    },

    /**
     * Обработчик события сохранения стратегии\
     * @param {jQuery.Event} event
     * @param {Object} data - данные для сохранения на сервер
     * @param {String} data.name - имя кампании, например, autobudget_avg_click
     * @param {String} data.platform - платформа показа
     * @param {Object} data.options - настройки стратегии
     * @param {Object} data.dayBudgetData - данные дневного бюджета
     * @private
     * @override
     */
    _onSaveStrategy: function(event, data) {

        this._currentSaveData = data;

        this.reachGoals({
            strategyData: this._campaignModel.get('strategy2').toJSON(),
            dayBudgetData: this._campaignModel.get('day_budget2').toJSON()
        }, this._getCampaignModelData(data));

        this
            .setMod('loading', 'yes')
            .trigger('ready-to-save');
    },

    /**
     * Сохраняет стратегию, отправляя запрос в бэкенд
     * При успехе обновляет модель стратегии в кампании и vm блока
     * При ошибке останавливает сохранение
     * @returns {Deferred}
     */
    saveToServer: function() {
        var params = this.params,
            dmData = this._getCampaignModelData(this._currentSaveData),
            errorMsg = iget2('b-campaign-strategy2', 'ne-udalos-sohranit-strategiyu', 'Не удалось сохранить стратегию'),
            ajaxData = {
                cid: this._campaignModel.get('cid'),
                cmd: 'ajaxSaveAutobudget',
                ulogin: params.ulogin || '',
                json_strategy: u['b-campaign-strategy2']
                    .buildStrategyOptionsJSON(dmData.strategyData, this._campaignModel.get('mediaType')),
                context_limit: dmData.contextLimit,
                enable_cpc_hold: dmData.enable_cpc_hold,
                attribution_model: dmData.attributionModel
            },
            deferred = $.Deferred();

        if (this.model.get('dayBudgetEnabled')) {
            ajaxData.json_day_budget = u['b-campaign-strategy2']
                .buildDayBudgetOptionsJSON(dmData.dayBudgetData, this._dayBudgetEnabled);
        }

        BEM.create('i-request_type_ajax', {
            type: 'post',
            url: params.script,
            timeout: 2000000,
            dataType: 'json',
            callbackCtx: this
        }).get(
            ajaxData,
            function(response) {
                if (response.success) {
                    this._doSave(dmData);
                    this.model.update(this._getViewModelData());
                    this._closePopup();
                    deferred.resolve();
                } else {
                    deferred.reject(response.error || errorMsg);
                    this.delMod('loading');
                }
            },
            function() {
                deferred.reject(errorMsg);
                this.delMod('loading');
            }
        );

        return deferred;
    },

    /**
     * Отмена операции сохранения
     */
    cancelSaving: function() {
        this.delMod('loading');
    },

    /**
     * Отправка целей в метрику
     */
    reachGoals: function(initData, newData) {
        var initDayBudget = initData.dayBudgetData || {},
            newDayBudget = newData.dayBudgetData || {},
            counter = BEM.blocks['b-metrika2'];

        if (initDayBudget.set && !newDayBudget.set) {
            counter.reachGoal('COMPANY_DAILY_LIMIT_OFF', {
                COMPANY_DAILY_LIMIT_OFF: {
                    beforeLimit: initDayBudget.sum
                }
            });
            counter.reachGoal('DAILY_BUDGET_LIMIT_CAMPAIGN_OFF');
        } else if (initDayBudget.set && newDayBudget.set && initDayBudget.sum < newDayBudget.sum) {
            counter.reachGoal('COMPANY_DAILY_LIMIT_UP', {
                COMPANY_DAILY_LIMIT_UP: {
                    difference: newDayBudget.sum - initDayBudget.sum
                }
            });
            counter.reachGoal('DAILY_BUDGET_LIMIT_CAMPAIGN_INCREASE');
        } else if (initDayBudget.set && newDayBudget.set && initDayBudget.sum > newDayBudget.sum) {
            counter.reachGoal('DAILY_BUDGET_LIMIT_CAMPAIGN_DECREASE');
        }
    }

});
