/**
 * Блок выбора и настройки стратегии рекламной кампании
 * Параметры:
 * {Object} ctx.campDataModel – модель кампании
 * {String} ctx.campDataModel.name – название модели данных кампании
 * {String} ctx.campDataModel.id – id модели данных кампании
 * {String} ctx.script – текущий url (без параметров)
 * {String} ctx.ulogin – логин пользователя
 * {Boolean} ctx.isNetStrategyEnabled - флаг определяющий можно ли включать стратегии в сетях
 */
block('b-campaign-strategy2')(

    mode('strategies')(function() {
        return {
            autoFirst: true,
            auto: [
                u.strategy.AUTOBUDGET_AVG_CPA,
                u.strategy.AUTOBUDGET_ROI,
                u.strategy.AUTOBUDGET_AVG_CLICK
            ],
            hand: [
                u.strategy.MAXIMUM_CLICKS
            ]
        };
    }),

    js()(function() {
        var campaignType = this.ctx.campaignType,
            isCpaPayForConversionsStrategyAllowed;
        switch (campaignType) {
            case 'text':
            case 'performance':
            case 'dynamic':
                isCpaPayForConversionsStrategyAllowed = u.consts('isCpaPayForConversionsExtendedModeStrategyAllowed');
                break;
            case 'mobile_content':
                isCpaPayForConversionsStrategyAllowed = u.consts('isCpaPayForConversionsMobileContentStrategyAllowed');
                break;
            default:
                isCpaPayForConversionsStrategyAllowed = false;
                break;
        }

        return {
            modelName: 'b-campaign-strategy2',
            campaignType: this.ctx.campaignType,
            script: this.ctx.script,
            ulogin: this.ctx.ulogin,
            campDataModel: this.ctx.campDataModel,
            strategies: apply('strategies'),
            dayBudgetSettings: this.ctx.dayBudgetSettings,
            walletInfo: this.ctx.walletInfo,
            isChangeManualStrategyName: this.ctx.isChangeManualStrategyName,
            isCpaPayForConversionsStrategyAllowed: isCpaPayForConversionsStrategyAllowed,
            conversionStrategyLearningStatusEnabled: u.consts('conversionStrategyLearningStatusEnabled'),
            isSavedPeriodStrategyEditable: this.ctx.isSavedPeriodStrategyEditable
        };
    }),

    content()(function() {
        var hintAboveControl = this.ctx.hintAboveControl || false,
            hint = {
                elem: 'strategy-hint',
                mix: hintAboveControl ? this.ctx.hintMixes : [],
                content: [
                    {
                        elem: 'model-field',
                        mix: {
                            elem: 'strategy-hint-content'
                        },
                        js: { name: 'strategyOptionsHint', type: 'inline-bemhtml' }
                    },
                    this.ctx.dayBudgetSettings.showOptionsHint && {
                        elem: 'model-field',
                        js: { name: 'dayBudgetOptionsHint', type: 'inline' }
                    },
                    {
                        elem: 'hint-forecast',
                        content: {
                            elem: 'simple-forecast'
                        }
                    },
                    {
                        elem: 'study-strategy-status',
                        elemMods: {
                            hidden: 'yes'
                        }
                    }
                ]
            },
            res = [
                {
                    elem: 'strategy-title',
                    mix: this.ctx.hintMixes,
                    content: {
                        elem: 'model-field',
                        js: { name: 'title', type: 'inline' },
                        mix: { block: 'hint-row' }
                    }
                },
                {
                    elem: 'presetting'
                },
                this.ctx.isMobileAppNotPreselected && {
                    elem: 'strategy-warning',
                    elemMods: { hidden: 'yes' },
                    content: iget2('b-campaign-strategy2', 'choose-app-to-select-strategy', 'Выберите приложение, чтобы указать стратегию')
                },
                // hintAboveControl && hint
                {
                    block: 'spin',
                    js: true,
                    mods: { progress: 'yes', theme: 'gray-16' },
                    mix: [{ block: 'b-campaign-strategy2', elem: 'spin' }]
                },
                {
                    elem: 'switcher',
                    strategies: apply('strategies'),
                    campDataModel: this.ctx.campDataModel,
                    dayBudgetSettings: this.ctx.dayBudgetSettings,
                    theme: this.ctx.theme
                }
                // hintAboveControl || hint
            ];

        res.splice(hintAboveControl ? 1 : res.length, 0, hint);

        return res;
    }),

    elem('hidden-input').content()(function() {
        return {
            elem: 'input',
            mix: {
                elem: 'model-field',
                js: {
                    name: this.ctx.modelField,
                    type: 'native'
                }
            },
            tag: 'input',
            attrs: { name: this.ctx.name, type: 'hidden' }
        };
    }),

    elem('switcher').def()(function() {
        return applyCtx({
            block: 'button',
            mods: {
                pseudo: 'yes',
                theme: this.ctx.theme || 'normal'
            },
            mix: [{ block: 'b-campaign-strategy2', elem: 'switcher' }],
            // strategies: apply('strategies'),
            // campDataModel: this.ctx.campDataModel,
            // dayBudgetSettings: this.ctx.dayBudgetSettings,
            content: iget2('b-campaign-strategy2', 'izmenit', 'Изменить')
        });
    }),

    mod('view-only', 'yes').elem('switcher').def()(''),

    mod('with-hidden-input', 'yes').content()(function() {
        return [
            applyNext(),
            {
                elem: 'hidden-input',
                modelField: 'settingsJSON',
                name: 'json_strategy'
            },
            {
                elem: 'hidden-input',
                modelField: 'dayBudgetSettingsJSON',
                name: 'json_day_budget'
            },
            {
                elem: 'hidden-input',
                modelField: 'selectedGoalJSON',
                name: 'json_fallback_selected_goal'
            }
        ];
    })
);
