/**
 * Блок настройки стратеги РК
 *
 * @event b-campaign-strategy2#popup-show popup стал виден
 * @event b-campaign-strategy2#save-click клик по кнопке "Сохранить"
 *
 * @fires b-campaign-strategy2#popup-show popup
 * @fires b-campaign-strategy2#save-click
 */
BEM.DOM.decl({ name: 'b-campaign-strategy2', baseBlock: 'i-glue' }, {

    onSetMod: {
        js: function() {
            u.graspSelf.call(this, {
                _switcher: '? button inside switcher',
                _spin: 'spin on spin'
            });

            this.setMod('loading', 'yes');

            this._campaignModel = BEM.MODEL.getOne({
                name: this.params.campDataModel.name,
                id: this.params.campDataModel.id
            });

            this._mediaType = this._campaignModel.get('mediaType');
            this._dayBudgetEnabled = this.params.dayBudgetSettings.isEnabled;
            this._subMan = BEM.create('i-subscription-manager');

            this.__base.apply(this, arguments);

            this.model.update(this._getViewModelData());

            // стратегии не настраиваются для архивных (например) кампаний
            if (!this.hasMod('view-only') || this.getMod('view-only') === 'no') {
                this._initSwitcher();
            }

            if (this._campaignModel.get('metrika_counters')) {
                this._subMan.on(this._campaignModel, 'metrika_counters', 'change', function() {
                    this.elem('strategy-hint-content').html(BEMHTML.apply(this._getStrategyOptionsHint()));
                }, this);
            }

            this.delMod('loading');
            this._initStudyStrategyStatus();
        },

        loading: function(modName, modVal) {
            this
                .setMod(this.elem('spin'), 'hidden', modVal !== 'yes' ? 'yes' : '')
                .setMod(this.elem('strategy-title'), 'hidden', modVal)
                .setMod(this.elem('strategy-hint'), 'hidden', modVal);

            this._popup && this._popup.toggleClose(modVal == 'yes');
            this._strategyChoose && this._strategyChoose.setMod('loading', modVal);

            this._spin.setMod('progress', modVal);
        }
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this._strategyChoose && this._strategyChoose.destruct();
        this._popup && this._popup.destruct();

        this.__base.apply(this, arguments);
    },

    isValid: function() {
        return true; // по-умолчанию валидация происходит в попапе, и блок всегда валидный
    },

    /**
     * Код вынесен из JS секции для переопределения
     * @private
     */
    _initSwitcher: function() {
        this._subMan.on(this._switcher, 'click', function() {
            this.trigger('switcher-click');
            this._switcher.domElem.blur();
            this._initPopup(this._campaignModel);
        }, this);
    },

    /**
     * Собирает данные для модели на основе данных стратегии в кампании
     * @returns {{settingsJSON: *, dayBudgetSettingsJSON: *, title: *,
     *      strategyOptionsHint: String, dayBudgetEnabled: (boolean|*), dayBudgetOptionsHint: string}}
     * @private
     */
    _getViewModelData: function() {
        var strategyData = this._campaignModel.get('strategy2').toJSON(),
            dayBudgetData = this._campaignModel.get('day_budget2').toJSON(),
            isCpaPayForConversionEnabled = this._campaignModel.get('isCpaPayForConversionEnabled'),
            metrikaData = this._campaignModel.hasField('metrika') && this._campaignModel.get('metrika').toJSON(),
            campaignData = this._campaignModel.toJSON(),
            currency = campaignData.currency,
            goalId = (strategyData.options.goal_id ||
                (strategyData.options.search || {}).goal_id ||
                (strategyData.options.net || {}).goal_id),
            selectedGoal = {},
            goal;

        if (metrikaData && goalId) {
            if (isCpaPayForConversionEnabled) {
                goal = metrikaData.campaign_goals
                        .find(function(goal) { return +goal.id === +goalId; });

                goal && (selectedGoal[goalId] = goal);
            } else {
                goal = metrikaData.campaign_goals.find(function(goal) { return +goal.goal_id === +goalId; });

                if (!goal) {
                    goal = this.params.fallbackGoal
                }
                goal && (selectedGoal[goalId] = goal);
            }

        }

        return {
            settingsJSON: u['b-campaign-strategy2']
                .buildStrategyOptionsJSON(strategyData, this._mediaType),
            dayBudgetSettingsJSON: u['b-campaign-strategy2']
                .buildDayBudgetOptionsJSON(dayBudgetData, this._dayBudgetEnabled),
            title: u['b-campaign-strategy2'].getStrategyTitle(
                strategyData,
                this._mediaType,
                this.params.isChangeManualStrategyName
            ),
            strategyOptionsHint: this._getStrategyOptionsHint(),
            dayBudgetEnabled: this._dayBudgetEnabled,
            dayBudgetOptionsHint: this._dayBudgetEnabled && strategyData ?
                u.strategy.getDayBudgetHint({ dayBudget: dayBudgetData, currency: currency }) :
                '',
            selectedGoalJSON: JSON.stringify(selectedGoal),
            contextLimit: campaignData.ContextLimit,
            enable_cpc_hold: campaignData.enable_cpc_hold
        }
    },

    _getStrategyOptionsHint: function() {
        var campaignData = this._campaignModel.toJSON(),
            strategyData = this._campaignModel.get('strategy2').toJSON();

        return this._getStrategyHint({
            strategyData: strategyData,
            currency: campaignData.currency,
            // добавляем к данным метрики данные РМП-счетчиков
            metrika: u._.extend({}, campaignData.metrika, campaignData.rmpCounters),
            hasNoMetrikaCounters: !campaignData.metrika_counters,
            onlyNet: u.campaign.isCpm(this._mediaType),
            onlySearch: u._.contains(['mcbanner', 'content_promotion'], this._mediaType),
            isChangeManualStrategyName: this.params.isChangeManualStrategyName,
            contextLimit: campaignData.ContextLimit,
            enable_cpc_hold: campaignData.enable_cpc_hold,
            attributionModel: campaignData.attribution_model,
            needAttributionModel: u['attribution-model'].isNewPolicyEnabled(this._mediaType),
            mediaType: this._mediaType,
            isCpaPayForConversionEnabled: this._campaignModel.get('isCpaPayForConversionEnabled'),
        })
    },

    /**
     * При отмене закрывает попап
     * @private
     */
    _onCancel: function() {
        this._closePopup();
    },

    /**
     * Обработчик события сохранения стратегии
     * @param {jQuery} event - событие
     * @param {Object} data - данные от блока настроек стратегии
     * @private
     */
    _onSaveStrategy: function(event, data) {
        this.trigger('save-click');

        this._doSave(this._getCampaignModelData(data));

        this._closePopup();
    },

    /**
     * Маппит данные от блока настроек стратегии в данные для модели стратегии в кампании
     * @param {Object} data - данные от блока настроек стратегии
     * @protected
     */
    _getCampaignModelData: function(data) {
        var name = data.name,
            options = data.options,
            platform = data.platform;

        //применяем МАППИНГ для ручных стратегий
        if (name === u.strategy.MAXIMUM_CLICKS) {
            name = options.name;
            options = options.options;
        }

        // исключаем Смарт-баннеры т.к. для них нет ручного управления ставками, соответственно для них не может быть name === DIFFERENT_PLACES
        if (platform === u.strategy.NET && !u._.contains(['performance'], this._mediaType)) {
            options = this._getDifferentPlacesOptions(options, name);
            name = u.strategy.DIFFERENT_PLACES;
        }

        return {
            strategyData: {
                name: name,
                is_net_stopped: platform === u.strategy.SEARCH,
                is_search_stopped: platform === u.strategy.NET,
                options: options
            },
            dayBudgetData: data.dayBudgetData,
            contextLimit: data.contextLimit,
            enable_cpc_hold: data.enable_cpc_hold,
            attributionModel: data.attributionModel,
            isCpaPayForConversionEnabled: data.isCpaPayForConversionEnabled
        };
    },

    /**
     * Сохранение данных: апдейт модели стратегии в кампании
     * И перезаписываем данные дневного бюджета
     * @param {Object} data - данные для сохранения
     * @private
     */
    _doSave: function(data) {
        var strategyModel = this._campaignModel.get('strategy2'),
            dayBudgetData = data.dayBudgetData ? data.dayBudgetData : { set: false },
            contextLimit = data.contextLimit,
            enable_cpc_hold = data.enable_cpc_hold;

        strategyModel
            .update(data.strategyData)
            .fix();

        this._campaignModel.get('day_budget2')
            .update(dayBudgetData)
            .fix();

        this._campaignModel.set('ContextLimit', contextLimit);
        this._campaignModel.set('enable_cpc_hold', enable_cpc_hold);
        this._campaignModel.set('attribution_model', data.attributionModel);
        this._campaignModel.set('isCpaPayForConversionEnabled', data.isCpaPayForConversionEnabled);

        this.model.update(this._getViewModelData());
    },

    /**
     * МАППИНГ: из модели кампании в name, options и platform
     * эти данные принимает b-strategy2-choose
     * @param {Object} data - данные модели
     * @returns {{options: Object, name: String, platform: String, dataName: String, isDifferentPlaces: Boolean,
     *  campaign: Object, where: String, minGoalsOnCampaign: String, needHints: Boolean}}
     * @private
     */
    _mapCampaignDataToChooseData: function(data) {
        var options = data.options,
            dataName = data.name,
            isNetStopped = data.is_net_stopped,
            isSearchStopped = data.is_search_stopped,
            platform = u.strategy.getPlatform(options, isNetStopped),
            name = u.strategy.getNameByPlatform(platform, dataName, options),
            isNetCompanies = ['cpm_banner', 'cpm_deals'],
            isNet = u._.contains(isNetCompanies, this._mediaType),
            selectedTab = isNetStopped ? 'search' : isSearchStopped ? 'net' : 'all';

        return {
            options: u._.cloneDeep(options),
            name: name,
            platform: isNet ? u.strategy.NET : selectedTab,
            dataName: dataName,
            isDifferentPlaces: dataName === u.strategy.DIFFERENT_PLACES,
            campaign: u._.cloneDeep(this._campaignModel.toJSON()),
            where: isNet ? 'context' : 'search',
            minGoalsOnCampaign: u.consts('MIN_GOALS_ON_CAMPAIGN'),
            needHints: true,
            lastStrategyChange: data.lastStrategyChange
        };
    },

    /**
     * Формирование настроек дневного бюджета на основе модели и
     * параметров в сервера
     * @param {Object} settings - настройки ДБ с сервера
     * @param {Object} data - модель дневного бюджета
     * @returns {Object} - настройки дневного бюджета
     * @private
     */
    _mapToDayBudget2Data: function(settings, data) {
        var modelData = {
            isSet: data.set,
            timesChangedToday: data.daily_change_count,
            showMode: data.show_mode,
            sum: data.sum
        };
        return u._.assign({}, settings, modelData);
    },

    /**
     * Для стратегии "раздельное управление" = "только в сетях" отдельно обрабатываем опции
     * @param {Object} options настройки стратегии
     * @param {String} name имя стратегии
     * @returns {Object} - настройки всего (с учетом different_places)
     * @private
     */
    _getDifferentPlacesOptions: function(options, name) {
        var opts = {
            search: { name: 'stop' },
            net: { name: name }
        };

        if (opts.net.name !== 'maximum_coverage') {
            opts.net = u._.extend(opts.net, options)
        }

        return opts;
    },

    /**
     * Инициализация попапа стратегий
     * @param {Object} campaignModel - модель кампании
     * @private
     */
    _initPopup: function(campaignModel) {
        var strategyData = campaignModel.get('strategy2').toJSON(),
            dayBudgetData = campaignModel.get('day_budget2').toJSON();

        if (this._popup && this._popup.isShown()) return;

        // всегда создаем попап заново
        this._popup = BEM.DOM.blocks['b-modal-popup-decorator'].create2(undefined, { bodyScroll: false }, $);
        // чтобы блоки с live-инициализацией и i-glue модели корректно отрабатывали,
        // надо, чтобы все блоки добавлялись в dom сразу
        this._popup.show();

        var disablePlatformChange = ['cpm_banner', 'cpm_deals', 'mcbanner', 'content_promotion', 'cpm_yndx_frontpage'];

        this._strategyChoose = this._popup.setPopupContent(
            {
                block: 'b-campaign-strategy2-decorator',
                mods: { type: this.getMod('campaign-type') || 'default' },
                campaignPeriod: {
                    start: campaignModel.get('start_date'),
                    finish: campaignModel.get('finish_date')
                },
                strategies: this.params.strategies,
                dayBudgetSettings: this._mapToDayBudget2Data(this.params.dayBudgetSettings, dayBudgetData),
                strategyModel: this._mapCampaignDataToChooseData(strategyData),
                disablePlatformChange: u._.contains(disablePlatformChange, this._mediaType),
                walletInfo: this.params.walletInfo,
                isChangeManualStrategyName: this.params.isChangeManualStrategyName,
                contextLimit: campaignModel.get('ContextLimit'),
                enable_cpc_hold: campaignModel.get('enable_cpc_hold'),
                campaignType: this._mediaType,
                attributionModel: campaignModel.get('attribution_model'),
                isCpaPayForConversionEnabled: campaignModel.get('isCpaPayForConversionEnabled'),
                isCpaPayForConversionsStrategyAllowed: this.params.isCpaPayForConversionsStrategyAllowed,
                isSavedPeriodStrategyEditable: this.params.isSavedPeriodStrategyEditable,
                impressionStandardTime: campaignModel.get('impression_standard_time'),
                eshowsBannerRate: campaignModel.get('eshows_banner_rate'),
                eshowsVideoRate: campaignModel.get('eshows_video_rate'),
                eshowsVideoType: campaignModel.get('eshows_video_type')
            }).getChooser();

        this._strategyChoose.setDayBudgetEvent(this._onDayBudgetChange.bind(this));
        this._initEvents();
    },

    /**
     * Инициализация событий на попапе
     * @private
     */
    _initEvents: function() {
        this._subMan.un(this._strategyChoose, 'cancel save');
        this._subMan.un(this._popup, 'close-blocked');

        this._subMan.wrap(this._strategyChoose)
            .on('cancel', function() {
                this._onCancel();
            }, this)
            .on('save', this._onSaveStrategy, this);

        this._subMan.wrap(this._popup)
            .on('close-blocked', function(e) {
                // отмена при наличии изменений
                BEM.blocks['b-confirm'].open({
                    message: iget2('b-campaign-strategy2', 'izmeneniya-ne-budut-sohraneny', 'Изменения не будут сохранены. Продолжить?'),
                    fromPopup: this._popup.getPopup(),
                    onYes: function() {
                        this._onCancel();
                    }.bind(this)
                }, this);
            }, this)
            .on('close', function() {
                this._popup && this._popup.destruct();
                this._switcher.domElem.focus();
            }, this);
    },

    /**
     * Закрывает и уничтожает попап
     * @private
     */
    _closePopup: function() {
        this._popup.hide({ force: true });
    },

    /**
     * Получение хинта для стратегий
     * @param {Object} options - опции
     * @param {Object} options.strategyData - данные стратегии
     * @param {String} options.currency - валюта
     * @param {Object} options.metrika - данные метрики
     * @param {Boolean} options.hasNoMetrikaCounters - указаны ли счётчики метрики на кампанию
     * @param {Boolean} [options.onlyNet] - флаг, принудительно использовать не для всех площадок
     * @param {Number} [options.contextLimit] - процент бюджета на показы в сетях
     * @param {String} [options.needAttributionModel] - доступно ли редактирование модели атрибуции в попапе стратегий
     * @param {boolean} [options.attributionModel] - значение модели атрибуции
     * @param {String} [options.mediaType] - тип кампании
     * @returns {Array}
     * @private
     */
    _getStrategyHint: function(options) {
        return u.strategy.getHint(options).map(function(hintPart) {
            return {
                block: 'b-campaign-strategy2',
                elem: 'hint-row',
                content: hintPart
            };
        });
    },

    /**
     * Показываем или скрываем warning об выборе приложения, для получения доступа к стратегиям
     * @param {String} modVal
     * @private
     */
    _setStrategyWarningVisible: function(modVal) {
        this
            .setMod(this.elem('strategy-title'), 'hidden', modVal)
            .setMod(this.elem('strategy-hint'), 'hidden', modVal)
            .setMod(this.elem('switcher'), 'hidden', modVal)
            .setMod(this.elem('presetting'), 'hidden', modVal)
            .setMod(this.elem('strategy-warning'), 'hidden', modVal === 'yes' ? '' : 'yes');
    },

    /**
     * обработчик на событие
     * превышения максимального количества смен дневного бюджета в сутки
     * @param {Function} onOkClick - обработчик нажатия на Ок
     * @private
     */
    _onDayBudgetChange: function(onOkClick) {
        var maxDailyChangeCount = this.params.dayBudgetSettings.maxDailyChangeCount;

        BEM.blocks['b-confirm'].open({
            message: iget2('b-campaign-strategy2', 'dnevnoy-byudzhet-mozhno-menyat', 'Дневной бюджет можно менять не более {foo} в день.', {
                foo: maxDailyChangeCount +
                ' ' +
                u.pluralizeWord([iget2('b-campaign-strategy2', 'raza', 'раза'), iget2('b-campaign-strategy2', 'raz', 'раз'), iget2('b-campaign-strategy2', 'raz', 'раз')], maxDailyChangeCount)
            }),
            type: 'alert',
            hasClose: false,
            isAlertUnclosable: true,
            fromPopup: this._popup.getPopup(),
            onYes: function() {
                onOkClick();
            }.bind(this),
            onNo: function() {
                onOkClick();
            }.bind(this)
        });
    },

    _initStudyStrategyStatus: function() {
        if (!this.params.conversionStrategyLearningStatusEnabled) {
            return;
        }

        var availableMediaTypes = {
            text: true,
            dynamic: true,
            performance: true
        };

        if (!availableMediaTypes[this._mediaType]) {
            return;
        }

        var availableStrategyTypes = {
                autobudget: true,
                autobudget_avg_cpa: true,
                autobudget_optimization_cpa: true
            },
            strategy = this._campaignModel.get('strategy2'),
            strategyOptions = strategy.get('options'),
            strategyName = strategy.get('name'),
            netStrategyName = strategyOptions.net && strategyOptions.net.name,
            searchStrategyName = strategyOptions.search && strategyOptions.search.name,
            strategyGoalId = strategyOptions.goal_id ||
                strategyOptions.net && strategyOptions.net.goal_id ||
                strategyOptions.search && strategyOptions.search.goal_id,
            strategyNameAvailableForShowStrategyStatus = (
                availableStrategyTypes[strategyName] ||
                availableStrategyTypes[searchStrategyName] ||
                availableStrategyTypes[netStrategyName]
            ),
            isSelectedMeaningfulGoalsOptimizationGoalId = strategyGoalId == u.consts('MEANINGFUL_GOALS_OPTIMIZATION_GOAL_ID');

        if (!strategyNameAvailableForShowStrategyStatus || isSelectedMeaningfulGoalsOptimizationGoalId) {
            return;
        }

        var dna = window.dna;

        if (!dna || !dna.utils || !dna.utils.getQueryExecutor) {
            throw new Error('An error has occurred in loading DNA dependencies');
        }

        var queryExecutor = dna.utils.getQueryExecutor(this.params.ulogin);

        queryExecutor.getStudyStrategyStatus(this.params.ulogin, this.params.campDataModel.id)
            .then((function(studyStrategyStatus) {
                if (!studyStrategyStatus) {
                    return;
                }

                var statusType;

                switch (studyStrategyStatus) {
                    case 'LEARNING':
                        statusType = 'learning';
                        break;

                    case 'LEARNED':
                        statusType = 'learned';
                        break;

                    case 'NOT_LEARNED':
                        statusType = 'not-learned';
                        break;
                }

                BEM.DOM.replace(
                    this.findElem('study-strategy-status'),
                    BEMHTML.apply({
                        block: this.__self.getName(),
                        elem: 'study-strategy-status',
                        status: studyStrategyStatus,
                        elemMods: {
                            type: statusType
                        }
                    })
                );
            }).bind(this))
            .catch(function() {});
    }
});
