u.register({

    'b-campaign-strategy2': {

        /**
         * Получение заголовка стратегии по данным от модели кампании
         * @param {Object} strategy - данные модели
         * @param {String} mediaType - тип кампании
         * @param {boolean} [isChangeManualStrategyName] - флаг фичи, характеризующий изменение названия ручной стратегии
         * @returns {String}
         */
        getStrategyTitle: function(strategy, mediaType, isChangeManualStrategyName) {
            var name = strategy.name,
                is_search_stopped = name === 'different_places' && strategy.options.search.name === 'stop',
                is_net_stopped = strategy.is_net_stopped,
                platform = is_search_stopped ? 'net' : (is_net_stopped ? 'search' : 'all');

            if (is_search_stopped) {
                name = strategy.options.net.name
            }

            return u.strategy.getTitleByName(name, platform, mediaType, strategy.options, isChangeManualStrategyName);
        },

        /**
         * Создает JSON стратегий для отправки на сервер
         * @param {Object} strategy - данные стратегии от модели кампании
         * @param {String} mediaType - тип кампании
         */
        buildStrategyOptionsJSON: function(strategy, mediaType) {
            var settings = strategy.options,
                is_net_stopped = strategy.is_net_stopped,
                is_search_stopped = strategy.is_search_stopped,
                serverSideName,
                serverSideSettings,
                mapOptimizationStrategy = function(settings, place) {
                    var res;

                    serverSideName = settings.originName;
                    serverSideSettings = u._.extend(settings, { name: serverSideName });

                    serverSideSettings = u._.omit(serverSideSettings, ['originName', 'target']);

                    res = { name: serverSideName };
                    res[place] = serverSideSettings;

                    return res;
                };

            settings.name = strategy.name;

            // если стратегия ручная для ГО на поиске, подменяем на default
            if (settings.name == 'search_maximum_coverage') {
                settings.name = 'default';
            }

            if (mediaType === 'performance') {
                // "place" должен быть равен "net" в случае если не включена фича показа "на поиске" или если выбрана платформа "net"
                // в остальных случаях "place" равен "search" (выбрана платформа "search" или "all")
                var place;

                if (is_search_stopped) {
                    place = 'net'
                } else {
                    place = 'search';
                }

                // Для перфоманс стратегий сервер ждет данные в отличном от всех остальных стратегий виде
                if (settings.name.match(/autobudget_optimization_(cpc|cpa)/)) {
                    settings = mapOptimizationStrategy(settings, place);
                } else {
                    if (settings.name === 'autobudget_roi') {
                        u._.forOwn(settings, function(val, key, obj) {
                            if (val === '') {
                                obj[key] = null;
                            }

                            // DIRECT-67668: М-видео: отправили в БК стратегию ROI без goal-id
                            if (key == 'goal_id' && !val) {
                                obj.goal_id = '0';
                            }
                        });
                    }

                    var oldSettings = settings;

                    settings = {
                        name: settings.name,
                    };

                    settings[place] = oldSettings;
                }

                if (is_net_stopped) {
                    settings.net = { name: 'stop' };
                } else if (is_search_stopped) {
                    settings.search = { name: 'stop' };
                }

            } else if (u.campaign.isCpm(mediaType)) {
                settings = {
                    name: u.strategy.DIFFERENT_PLACES,
                    net: u._.omit(settings.net, ['coverageWeekMode', 'coveragePeriodMode']),
                    search: { name: 'stop' }
                };
            } else if ((mediaType === 'mcbanner' || mediaType === 'content_promotion') &&
                settings.name === 'autobudget_optimization_cpc') {
                // для ГО на поиске оптимизация количества кликов работает так же, как и для Смартов, но на поиске
                settings = mapOptimizationStrategy(settings, 'search');
            } else {
                // преобразуем options в серверный формат
                if (settings.name !== 'different_places') {
                    settings = {
                        name: '',
                        search: settings,
                        net: { name: 'default' }
                    };
                }

                if (is_net_stopped) {
                    settings.net.name = 'stop';
                }
            }

            settings.is_net_stop = +is_net_stopped;

            return JSON.stringify(settings);
        },

        /**
         * Создает JSON дневного бюджета для отправки на сервер
         * @param {Object} dayBudgetData - данные дневного бюджета (как в модели кампании)
         * @param {Boolean} dayBudgetEnabled - включен ли дневной бюджет
         */
        buildDayBudgetOptionsJSON: function(dayBudgetData, dayBudgetEnabled) {
            return JSON.stringify({
                set: !!(dayBudgetEnabled && dayBudgetData && dayBudgetData.set),
                sum: (dayBudgetEnabled && dayBudgetData && dayBudgetData.sum) || '',
                show_mode: dayBudgetData ? dayBudgetData.show_mode : 'default'
            });
        },

        /**
         * Строит структуру стратегии по данным из кампании
         * @param {Object} campaign
         * @param {String} campaign.mediaType
         * @param {Object} campaign.strategy
         * @param {String} campaign.strategy.name
         * @param {Boolean} campaign.strategy.is_autobudget
         * @param {Object} [campaign.strategy.net]
         * @param {String} [campaign.strategy.net.name]
         * @param {Object} [campaign.strategy.search]
         * @param {String} [campaign.strategy.search.name]
         * @returns {Object}
         */
        buildStrategy: function(campaign) {
            var mediaType = campaign.mediaType,
                isPerformanceCampaign = mediaType === 'performance',
                isMcbanner = mediaType === 'mcbanner',
                isContentPromotion = mediaType === 'content_promotion',
                isCpmBanner = u.campaign.isCpm(mediaType),
                isSearchStop = campaign.strategy.is_search_stop || campaign.strategy.search.name === 'stop',
                where = isSearchStop ? 'net' : 'search',
                options,
                lastStrategyChangeTimeStamp = campaign.strategy[where].last_update_time;

            // todo выпилить в DIRECT-77130
            campaign.strategy = this._convertNoPremiumStrategy(campaign.strategy);

            // Стратегии для смартов действуют только на сети и приходят от сервера в отличном от остальных кампаний виде
            // - для стратегии РОИ приходят как и для остальных кампаний:
            //   { name: 'different_places', net: {...}, search: { name: 'stop' } }
            // - для остальных стратегий так: { name: 'net-strategy-name', , net: {...}, search: { name: 'stop' } }
            // Показать в интерфейсе стратегии для Смартов нужно как будто она не раздельное размещение
            if (isCpmBanner || (campaign.strategy.name === 'different_places') && !isPerformanceCampaign) {
                options = u._.pick(campaign.strategy, ['name', 'net', 'search']);
            } else {
                options = campaign.strategy[where];
            }

            return u['b-campaign-strategy2']._modifyStrategyData(
                {
                    options: options,
                    name: !isPerformanceCampaign && campaign.strategy.name ?
                        campaign.strategy.name : campaign.strategy[where].name,
                    is_autobudget: campaign.strategy.is_autobudget,
                    is_net_stopped: campaign.strategy.is_net_stop,
                    is_search_stopped: isSearchStop ? 1 : 0,
                    lastStrategyChange: lastStrategyChangeTimeStamp ?
                        u.moment(lastStrategyChangeTimeStamp).format('DD.MM.YYYY') :
                        undefined,
                    strategy_with_custom_period_min_available_budget:
                        campaign.strategy_with_custom_period_min_available_budget
                },
                {
                    isMcbanner: isMcbanner,
                    isContentPromotion: isContentPromotion
                }
            );
        },

        /**
         * Переводит на клиенте стратегию no_premium в default
         * todo можно выпилить когда ко всем пользователям со стратегией no_premium
         * todo выпилить в DIRECT-77130
         * @param {Object} strategy
         * @returns {Object}
         * @private
         */
        _convertNoPremiumStrategy: function(strategy) {
            if (strategy.search && (strategy.search.name === 'no_premium')) {
                strategy.search.name = u.strategy.DEFAULT;
            }
            if (strategy.name === 'no_premium') {
                strategy.name = u.strategy.DEFAULT;
            }

            return strategy;
        },

        /**
         * Модифицирует данные для модели dm-campaign-strategy2
         * @see dm-campaign-strategy2
         * @param {Object} strategyData
         * @param {String} strategyData.name название стратегии
         * @param {Object} strategyData.options настройки стратегии
         * @param {Object} options - опции для модификации
         * @param {Boolean} options.isMcbanner - является ли кампания ГО на поиске
         * @param {Boolean} options.isContentPromotion - тип кампании "партнерский контент"
         * @returns {Object}
         * @private
         */
        _modifyStrategyData: function(strategyData, options) {
            var performanceStrategyData = strategyData.name.match(/autobudget_avg_(cpc|cpa)_per_(camp|filter)/);

            // для ГО на поиске и продвижения контента переименовываем стратегию default в search_maximum_coverage
            if ((options.isMcbanner || options.isContentPromotion) && strategyData.name === 'default') {
                strategyData.name = u.strategy.SEARCH_MAXIMUM_COVERAGE;
                strategyData.options.name = u.strategy.SEARCH_MAXIMUM_COVERAGE;
            }

            if (performanceStrategyData) {
                /*
                Дополнительная обработка для перфоманс стратегий (ДМО)

                В интерфейсе 2 таба для стратегии:
                    autobudget_optimization_cpc
                    autobudget_optimization_cpa

                    (не autobudget_avg_* , потому что autobudget_avg_cpa уже есть)

                на серверсайде 4 стратегии:
                    autobudget_avg_cpa_per_filter
                    autobudget_avg_cpc_per_filter
                    autobudget_avg_cpa_per_camp
                    autobudget_avg_cpc_per_camp

                Чтобы их подружить, при получении данных с серверсайда форматируем данные стратегии
                Например:
                    autobudget_avg_cpa_per_filter -> autobudget_optimization_cpa
                    и пробрасываем в options { target: filter }

                При сохранении в интерфейсе в скрытый инпут пишем с обратным преобразованием
                    autobudget_optimization_cpa +  { target: filter } -> autobudget_avg_cpc_per_filter
                */

                var type = performanceStrategyData[1],
                    target = performanceStrategyData[2],
                    clientSideName = 'autobudget_optimization_' + type;

                return u._.extend({}, strategyData, {
                    name: clientSideName,
                    options: u._.extend({}, strategyData.options, {
                        target: target,
                        name: clientSideName,
                        originName: strategyData.name
                    })
                });
            }

            return strategyData;
        },

        /**
         * Запрос к серверу за результатами прогноза для превью светофора
         * @param {Object} params параметры, сгенерированне в методе _getHintForecastParams
         * @returns {Promise}
         * @private
         */
        _getHintForecast: function(params) {
            return BEM.blocks['i-web-api-request'].mediareach
                .getCpmTrafficLightPrediction(u.consts('ulogin'), params)
                .then(function(data) {
                    var colors = ['red', 'yellow', 'green'];

                    if (data.result) {
                        return {
                            color: colors[data.result.traffic_light_color],
                            hint: {
                                id: data.request_id
                            }
                        };
                    } else {
                        return {
                            color: 'grey',
                            hint: {
                                id: data.request_id
                            },
                            errorCode: data.validation_result.errors[0].code
                        };
                    }
                });
        },

        /**
         * Формирует данные для запроса превью светофора
         * @param {dm-cpm-banner-campaign | dm-cpm-yndx-frontpage-campaign} campaignModel дата-модель кампании
         * @returns {{strategy: {end_date: *, cpm: (STORE.chart.children.avg_cpm|{text}), impression_limit: {days: (*|number), impressions: (*|number)}, type: string, budget: *, start_date: *}, campaign_id: any}}
         * @private
         */
        _getHintForecastParams: function(campaignModel) {
            var strategy = campaignModel.get('strategy2').toJSON().options.net,
                mediaType = campaignModel.get('mediaType'),
                multiplier = campaignModel.get('multipliersPct'),
                cid = campaignModel.get('cid'),
                rfReset = campaignModel.get('rfReset'),
                rf = campaignModel.get('rf'),
                startDate = strategy.start || u.moment().format('YYYY-MM-DD'),
                endDate = strategy.finish || u.moment().add('days', 6).format('YYYY-MM-DD'),
                strategyName = BEM.blocks['b-strategy2-settings'].getModNameByStrategyName(strategy.name),
                webApiStrategyName = (function(strategy) {
                    switch (strategy) {
                        case 'cpm-max-coverage':
                            return 'MAX_REACH';
                        case 'avg-cpv':
                            return 'AVG_CPV';
                        default:
                            return 'MIN_CPM';
                    }
                })(strategyName),
                impressionLimit = BEM.blocks['b-strategy2-settings'].getImpressionLimit(rf, rfReset, startDate, endDate),
                params = {
                    campaign_id: cid ? Number(cid) : null,
                    strategy: {
                        budget: strategy.sum || strategy.budget,
                        start_date: startDate,
                        end_date: endDate,
                        type: webApiStrategyName,
                        impression_limit: {
                            days: impressionLimit.rfReset,
                            impressions: impressionLimit.rf
                        },
                        auto_prolongation: strategy.auto_prolongation
                    },
                    traffic_type_corrections: BEM.blocks['b-strategy2-settings'].getTrafficTypeCorrections(multiplier)
                },
                allowed_frontpage_types = campaignModel.get('allowed_frontpage_types'),
                // при начальной загрузке страницы в этом поле массив, а после изменений в селекте - строка с JSON'ом
                frontpage_types = typeof allowed_frontpage_types === 'string' ?
                    JSON.parse(allowed_frontpage_types) :
                    allowed_frontpage_types,
                target_tags;

            if (strategyName === 'avg-cpv') {
                params.strategy.cpv = strategy.avg_cpv;
            } else {
                params.strategy.cpm = strategy.avg_cpm;
            }

            if (!cid) {
                var targetMode = strategy.coveragePeriodMode || strategy.coverageWeekMode;

                params.new_campaign_example_type = (targetMode === 'wide') ? 0 : 1;
                params.campaign_type = mediaType.toUpperCase();
            }

            if (mediaType === 'cpm_yndx_frontpage') {
                target_tags = u._.flatten(
                    frontpage_types.map(function(type) { return u.campaign.frontpageTypeToForecastFormat(type) })
                );

                params.target_tags = target_tags;
            }

            if (mediaType === 'cpm_banner' || mediaType === 'cpm_deals') {
                var eshowsSettings = {};

                if (
                    campaignModel.get('impression_standard_time').length ||
                    typeof campaignModel.get('impression_standard_time') === 'number'
                ) {
                    params.impression_standard_time = campaignModel.get('impression_standard_time');
                }

                if (
                    campaignModel.get('eshows_banner_rate').length ||
                    typeof campaignModel.get('eshows_banner_rate') === 'number'
                ) {
                    eshowsSettings.banner_rate = campaignModel.get('eshows_banner_rate') ? 'on' : 'off';
                }

                if (campaignModel.get('eshows_video_rate')) {
                    eshowsSettings.video_rate = campaignModel.get('eshows_video_rate') ? 'on' : 'off';
                    eshowsSettings.video_type = campaignModel.get('eshows_video_type');
                }

                if (Object.keys(eshowsSettings).length) {
                    params.eshows_settings = eshowsSettings;
                }
            }

            return params;
        }

    }

});
