block('b-campaign-tabs').mod('type', 'stat').def()(function() {
    var data = this.data,
        form = data.FORM,
        tab = data.statistic_page_type,
        params = {
            cid: data.cid,
            isStat: 1
        },
        tabs = [],
        boolParams = {
            target_all: form.target_all,
            target_0: form.target_0,
            target_1: form.target_1,
            with_nds: form.with_nds
        };

    form.interface && (params.interface = form.interface);
    data.user_login && (params.ulogin = data.user_login);
    form.goals && (params.goals = form.goals);

    Object.keys(boolParams).forEach(function(name) {
        boolParams[name] && (params[name] = 1);
    });

    if (form.d1) {
        ['d1', 'm1', 'y1', 'd2', 'm2', 'y2'].forEach(function(p) {
            params[p] = form[p];
        });

        form.group && (params.group = form.group);
        form.target_type && (params.target_type = form.target_type);
    }

    [
        {
            type: 'detail',
            title: iget2('b-campaign-tabs', 'statistika-po-dnyam', 'Статистика по дням'),
            params: {
                detail: 'Yes',
                types: 'days',
                showCampStat: 'cmd'
            }
        },
        {
            title: iget2('b-campaign-tabs', 'obshchaya-statistika', 'Общая статистика'),
            type: 'default',
            params: {
                types: 'total'
            }
        },
        {
            title: u.campaign.getPhraseDetailStatTitle(data.mediaType),
            type: 'phrase-detail',
            params: {
                phrasedate: 'Yes'
            }
        },
        {
            title: iget2('b-campaign-tabs', 'po-regionam', 'По регионам'),
            type: 'geo',
            params: {
                stat_type: 'geo'
            }
        },
        {
            title: iget2('b-campaign-tabs', 'po-ploshchadkam', 'По площадкам'),
            type: 'pages',
            params: {
                stat_type: 'pages'
            }
        },
        {
            title: iget2('b-campaign-tabs', 'master-otchyotov', 'Мастер отчётов'),
            type: 'custom',
            params: {
                stat_type: 'custom',
                with_auto_added_phrases: 1
            }
        },
        {
            title: 'Brand Lift',
            type: 'brand-lift',
            params: {
                stat_type: 'brand_lift'
            }
        }
    ].forEach(function(i) {
        tabs.push({
            title: i.title,
            url: u.getUrl('showCampStat', u._.extend(i.params, params)),
            active: tab == i.type
        });
    });

    data.offline_stat_count && delete params.interface && tabs.push({
        title: iget2('b-campaign-tabs', 'statistika-v-xls', 'Статистика в XLS'),
        count: data.offline_stat_ready_count,
        url: u.getUrl('listOfflineReports', params),
        active: tab == 'offline-reports'
    });

    u.consts('brandsafetyBaseCategoriesStat') && tabs.push({
        title: iget2('b-campaign-tabs', 'brand-safety', 'По Brand Safety'),
        type: 'brand_safety',
        params: {
            stat_type: 'brand_safety'
        }
    });

    return applyNext({
        tabs: tabs
    });
});
