block('b-campaign-tabs')(

    match(function() {
        return !(this.ctx.mods || {}).type;
    }).def()(function() {
        var data = this.data,
            form = data.FORM,
            userLogin = data.user_login,
            cid = data.cid,
            tab = data.tab || 'active',
            getTab = function(id, title, cmd, extraParams) {
                return {
                    title: title,
                    url: u.getUrl(
                        cmd || 'showCamp',
                        u._.extend({
                            ulogin: userLogin,
                            cid: cid,
                            tab: id,
                            interface: data.FORM.interface
                        }, extraParams)),
                    active: tab == id && !form.tag, // если перешли по тэгу - таб неактивен
                    id: id,
                    disabled: data['tabclass_' + id + '_count'] == 0,
                    count: data['tabclass_' + id + '_count']
                };
            },
            tabs = [
                getTab('all', iget2('b-campaign-tabs', 'vse-gruppy', 'Все группы')),
                getTab('active', iget2('b-campaign-tabs', 'aktivnye-129', 'Активные')),
                getTab('wait', iget2('b-campaign-tabs', 'na-moderacii', 'На модерации')),
                getTab('decline', iget2('b-campaign-tabs', 'otklonyonnye', 'Отклонённые')),
                getTab('off', iget2('b-campaign-tabs', 'ostanovlennye', 'Остановленные')),
                getTab('arch', iget2('b-campaign-tabs', 'arhiv', 'Архив'))
            ],
            optimizeCamp = data.optimize_camp,
            loginRights = data.login_rights,
            isSearchBanner = +data.is_search_banner;

        if (isSearchBanner) {
            tab = 'search';
            tabs.forEach(function(tabItem) {
                tabItem.active = false;
            });
            tabs.push(getTab('search', iget2('b-campaign-tabs', 'naydennye', 'Найденные')));
        }

        (loginRights.SendModerate || +data.tabclass_draft_count) && tabs.push(getTab('draft', iget2('b-campaign-tabs', 'chernoviki', 'Черновики')));

        //todo надо наверное разобраться с серверной частью и сократить эти адские условия?
        if (optimizeCamp && (
                (loginRights.role == 'client' && optimizeCamp.status == 'Ready') ||
                    (loginRights.FirstAid || loginRights.support_control) &&
                        (optimizeCamp.status == 'InProcess' || optimizeCamp.status == 'Ready'))) {
            //todo - Добавить optimize tick
            tabs.push(
                getTab('media', [{
                    block: 'b-icon',
                    mods: {
                        'size-13': 'tick'
                    }
                }, '&nbsp;' + iget2('b-campaign-tabs', 'rekomendacii', 'Рекомендации')], 'showMediaplan'));

        } else if (optimizeCamp && optimizeCamp.id && (loginRights.media_control || loginRights.super_control) &&
            (optimizeCamp.status == 'Declined' || optimizeCamp.status == 'New') ||
                loginRights.role == 'client' && (optimizeCamp &&
                    (optimizeCamp.status == 'New' || optimizeCamp.status == 'InProcess' ||
                        optimizeCamp.status == 'AutoRequest'))) {
            //нет вкладок
        } else if (data.manager_uid || (data.media && +data.media.count) || data.tab == 'media' ||
            loginRights.super_control) {

            if (!((loginRights.is_any_client || loginRights.agency_control) &&
                data.mediaplan_status != 'Complete' || data.tabclass_media_count == 0)) {

                tabs.push(u.consts('hasOptimizedCampMediaplan') ?
                    getTab('media', iget2('b-campaign-tabs', 'optimizirovannaya-kampaniya', 'Оптимизированная кампания'), 'showMediaplan', {
                        from: 'interface'
                    }) :
                    getTab('media', iget2('b-campaign-tabs', 'mediaplan', 'Медиаплан'), 'showMediaplan'));
            }
        }

        return applyNext({
            tabs: tabs
        });
    }),

    match(function() {
        return !!this.ctx.modelParams;
    }).js()(function() {
        return {
            modelParams: this.ctx.modelParams
        };
    }),

    mod('empty', 'no').content()(function() {
        return {
            block: 'b-menu-horiz',
            mods: {
                preset: 'shadow',
                layout: 'complex'
            },
            content: (this.ctx.tabs || this.tabs).map(function(value) {
                return {
                    elem: 'item',
                    elemMods: {
                        state: value.active ? 'current' : 'simple'
                    },
                    content: {
                        block: 'b-campaign-tabs',
                        elem: 'tab',
                        elemMods: {
                            id: value.id
                        },
                        count: value.count,
                        url: value.url,
                        disabled: value.disabled,
                        active: value.active,
                        title: value.title
                    }
                };
            }, this)
        };
    })
);
