BEM.DOM.decl('b-campaign-tabs', {
    onSetMod: {
        js: function() {
            (this.model = BEM.MODEL.getOne(this.params.modelParams))
                .on('countArchTab', 'change', this._onChangeCount.bind(this, 'arch'))
                .on('countOffTab', 'change', this._onChangeCount.bind(this, 'off'));

            this.bindTo('tab', 'click', function(e) {
                var id = this.elemInstance(e.data.domElem).getMod('id');
                BEM.blocks['b-metrika2'].params({
                    params: {
                        showCamp: {
                            'campaign-tabs': id
                        }
                    }
                });
            }.bind(this));
        }
    },

    /**
     * Обработчик изменения счетчика табов.
     *
     * @param {'arch'|'off'} idTab Id таба.
     * @param {Event} e Объект события
     * @param {Object} data Данные события.
     * @param {Number} data.value Новое значение счетчика.
     * @private
     */
    _onChangeCount: function(idTab, e, data) {
        this.renderTab(idTab, data.value);
    },

    /**
     * Получает там по id.
     *
     * @param {'arch'|'off'} id Id таба.
     * @return {BEM}
     * @private
     */
    _getTab: function(id) {
        return this.findElem('tab', 'id', id);
    },

    /**
     * Перерисовывает таб по id.
     *
     * @param {'arch'|'off'} id Id таба.
     * @param {Number} count Кол-во баннеров.
     * @public
     */
    renderTab: function(id, count) {
        this.__self.replace(this._getTab(id), BEMHTML.apply({
            block: 'b-campaign-tabs',
            elem: 'tab',
            elemMods: { id: id },
            count: count,
            url: u.getUrl('showCamp', {
                ulogin: u.consts('ulogin'),
                cid: this.model.get('cid'),
                tab: id
            }),
            disabled: !count,
            active: id === this.model.get('currentTab'),
            title: ({
                arch: iget2('b-campaign-tabs', 'arhiv', 'Архив'),
                off: iget2('b-campaign-tabs', 'ostanovlennye', 'Остановленные')
            })[id]
        }));
    }
});
