block('b-campaign-tags').elem('content').content()(function() {
    var ctx = this.ctx,
        tags = ctx.tags;

    return [
        {
            elem: 'tags',
            tags: tags,
            content: [
                !ctx.readonly && {
                    block: 'link',
                    mix: [{
                        block: 'b-campaign-tags',
                        elem: 'edit-link',
                        elemMods: { type: tags.length ? 'update' : 'create' }
                    }],
                    url: ctx.editTagsUrl,
                    content: tags.length ? iget2('b-campaign-tags', 'redaktirovat-metki', 'Редактировать метки') : iget2('b-campaign-tags', 'zadat-metki', 'Задать метки')
                },
                !!tags.reduce(function(res, next) {
                    res += next.uses_count;
                    return res
                }, 0) && ctx.untaggedNum > 0 && {
                    elem: 'show-untagged',
                    tag: 'span',
                    content: [
                        {
                            block: 'link',
                            mix: [{
                                block: 'b-campaign-tags',
                                elem: 'show-untagged-link'
                            }],
                            url: ctx.untaggedUrl,
                            content: ctx.untaggedText
                        },
                        {
                            elem: 'untagged-count',
                            tag: 'span',
                            content: ctx.untaggedNum
                        }
                    ]
                }
            ]
        }
    ];
});
