block('b-campaign-tags').elem('tags').match(function() { return this.ctx.tags; })(
    def()(function() {
        var maxThird = Math.round(u.consts('MAX_TAGS_FOR_CAMPAIGN') / 3),
            tagsLength = this.ctx.tags.length;

        return applyNext({
            'elemMods.size': tagsLength > 2 * maxThird ? 'l' : tagsLength > maxThird ? 'm' : 's'
        });
    }),

    content()(
        match(function() {
            return this.ctx.tags.length;
        })(function() {
            var _this = this;

            return [
                this.ctx.tags.map(function(tag) {
                    return {
                        elem: 'tag',
                        tag: 'span',
                        content: [
                            +tag.uses_count ?
                                {
                                    block: 'link',
                                    title: iget2('b-campaign-tags', 'otbor-po-metke', 'Отбор по метке'),
                                    url: tag.url,
                                    content: tag.value,
                                    mix: [
                                        {
                                            block: 'b-metrika2',
                                            js: {
                                                nativeEvent: 'click',
                                                params: {
                                                    showCamp: {
                                                        'filter-by-tag-click': true
                                                    }
                                                }
                                            }
                                        }
                                    ]
                                } :
                                tag.value,
                            {
                                elem: 'tag-counter',
                                tag: 'span',
                                content: tag.uses_count
                            }
                        ]
                    };
                }),
                {
                    content: applyNext()
                }
            ];
        }),

        match(function() {
            return !this.ctx.tags.length;
        })(function() {
            return [
                {
                    elem: 'empty-tags',
                    tag: 'span',
                    content: iget2('b-campaign-tags', 'u-vas-eshchyo-net', 'У вас ещё нет ни одной метки.')
                },
                {
                    content: applyNext()
                }
            ];
        })
    )
);
