BEM.DOM.decl('b-campaign-tags', {

    onSetMod: {

        js: function() {
            this.campaign = BEM.MODEL.getOne(this.params.modelParams);

            this.findBlockOutside('popup').on('show', this._updateTags, this);
        }

    },

    _updateTags: function() {
        var params = this.params,
            campaign = this.campaign,
            mediaType = campaign.get('mediaType');

        BEM.DOM.update(this.elem('content-container'),
            BEMHTML.apply({
                block: 'b-campaign-tags',
                elem: 'content',
                tags: campaign.get('tags', 'raw').map(function(tag) {
                    return {
                        tag_id: tag.get('id'),
                        value: tag.get('value'),
                        uses_count: tag.get('uses_count'),
                        url: BEM.blocks['i-utils'].formatUrl({
                            host: params.host,
                            query: $.extend(params.urlParams, { tag: tag.get('id') })
                        })
                    };
                }),
                untaggedNum: campaign.get('untagged_banners_num'),
                untaggedText: mediaType == 'mcbanner' || mediaType == 'performance' ?
                    iget2('b-campaign-tags', 'pokazat-bannery-bez-metok', 'Показать баннеры без меток') :
                    iget2('b-campaign-tags', 'pokazat-obyavleniya-bez-metok', 'Показать объявления без меток'),
                untaggedUrl: params.untaggedUrl,
                editTagsUrl: params.editTagsUrl,
                readonly: params.readonly
            }));
    }

});
