/**
 * Блок действий для единичной кампании в списке кампаний
 * @param {Object} modelParams параметры модели данной кампании
 * @private
 */

block('b-campaigns-list-item').elem('actions').content()(function() {
    var data = this.data,
        camp = this.camp,
        form = data.FORM,
        rights = data.login_rights,
        isSuperreader = hasLoginRights('superreader_control'),
        urlParams = {
            cid: camp.cid
        },
        jsParamsForDesc = {
            id: camp.cid,
            idField: 'cid'
        },
        action = camp.action || {},
        paction = camp.paction || {},
        currentUrl = decodeURIComponent(data.current_url),
        campDesc = camp.camp_description,
        linkDang = [],
        result = [],
        statUrl = u.getUrl('showStat', {
            cid: camp.cid,
            detail: 'Yes',
            types: 'days',
            ulogin: camp.login,
            single_camp: 1,
            stat_type: 'moc',
            show_stat: 1,
            date_from: u.moment().subtract(7, 'days').format('YYYY-MM-DD'),
            date_to: u.moment().format('YYYY-MM-DD')
        });

    this.can.showuid && (urlParams.ulogin = camp.login);

    if (form.tab === 'arch') {
        action.showCampStat && result.push({
            block: 'link',
            mods: {
                theme: 'dark-blue'
            },
            url: u.getUrl('showCampStat', this.extend(urlParams, {
                detail: 'Yes',
                types: 'days'
            })),
            content: action.showCampStat,
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'campStat'
                            }
                        }
                    }
                }
            ]
        });

        action.editCamp && result.push({
            block: 'link',
            mods: {
                theme: 'dark-blue'
            },
            url: u.getUrl('editCamp', this.extend(urlParams, {
                retpath: currentUrl
            })),
            content: action.editCamp,
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'editCamp'
                            }
                        }
                    }
                }
            ]
        });

        action.campUnarc && !isSuperreader && result.push({
            block: 'link',
            mods: {
                theme: 'dark-blue'
            },
            url: u.getUrl('campUnarc', this.extend(urlParams, {
                tab: form.tab
            })),
            content: action.campUnarc,
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'unarchive'
                            }
                        }
                    }
                }
            ]
        });

        action.showCampSettings && result.push({
            block: 'link',
            mods: {
                theme: 'dark-blue'
            },
            url: u.getUrl(rights.is_developer ? 'editCamp' : 'showCampSettings', this.extend(urlParams, {
                retpath: currentUrl
            })),
            content: action.showCampSettings,
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'showCampSettings'
                            }
                        }
                    }
                }
            ]
        });
    } else {
        action.pay && !camp.lowMonthShowsNoPay && this.can.add_money && result.push({
            block: 'link',
            mods: {
                theme: 'dark-blue'
            },
            url: u.getUrl('pay', urlParams),
            content: action.pay,
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'pay'
                            }
                        }
                    }
                }
            ]
        });

        action.createMediaplan && result.push({
            block: 'link',
            mods: {
                theme: 'dark-blue'
            },
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'mediaPlan'
                            }
                        }
                    }
                }
            ],
            url: u.getUrl(camp.has_mediaplan_banners ? 'showMediaplan' : 'createMediaplan', urlParams),
            content: camp.has_mediaplan_banners ? iget2('b-campaigns-list-item', 'posmotret-mediaplan', 'Посмотреть медиаплан') : action.createMediaplan
        });

        action.campArc && !isSuperreader && result.push({
            block: 'link',
            mods: {
                theme: 'dark-blue'
            },
            url: u.getUrl('campArc', urlParams),
            content: action.campArc,
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'archive'
                            }
                        }
                    }
                }
            ]
        });

        action.delCamp && result.push({
            block: 'link',
            mods: {
                theme: 'dark-blue'
            },
            mix: [
                {
                    block: 'b-campaigns-list-item',
                    elem: 'action',
                    elemMods: {
                        type: 'delete'
                    }
                },
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'delete'
                            }
                        }
                    }
                }
            ],
            url: u.getUrl('delCamp', urlParams),
            content: action.delCamp
        });

        action.showCampStat && result.push({
            block: 'link',
            mods: {
                theme: 'dark-blue'
            },
            url: statUrl,
            content: action.showCampStat,
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'campStat'
                            }
                        }
                    }
                }
            ]
        });

        action.editCamp && result.push({
            block: 'link',
            mods: {
                theme: 'dark-blue'
            },
            url: u.getUrl('editCamp', this.extend(urlParams, {
                retpath: currentUrl
            })),
            content: action.editCamp,
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'editCamp'
                            }
                        }
                    }
                }
            ]
        });

        action.showCampSettings && result.push({
            block: 'link',
            mods: {
                theme: 'dark-blue'
            },
            url: u.getUrl(rights.is_developer ? 'editCamp' : 'showCampSettings', this.extend(urlParams, {
                retpath: currentUrl
            })),
            content: action.showCampSettings,
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'showCampSettings'
                            }
                        }
                    }
                }
            ]
        });

        action.resumeCamp && result.push({
            block: 'link',
            mods: {
                type: 'switcher',
                theme: 'red'
            },
            url: u.getUrl('resumeCamp', urlParams),
            content: action.resumeCamp,
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'resumeCamp'
                            }
                        }
                    }
                }
            ]
        });

        action.stopCamp && result.push({
            block: 'link',
            mods: {
                theme: 'dark-blue',
                'need-confirm': u.campaign.isCpm(camp.mediaType) && camp.brand_survey_id ? 'yes' : ''
            },
            confirm: iget2(
                'b-campaigns-list-item',
                'dont-stop-campaign-with-brand-lift',
                'Исследование Brand Lift проводится на протяжении всей кампании. Не останавливайте кампанию досрочно — собранных данных может оказаться недостаточно для достоверных выводов'
            ),
            confirmOptions: {
                textYes: iget2('b-campaigns-list-item', 'yes', 'Остановить'),
                textNo: iget2('b-campaigns-list-item', 'no','Отменить'),
            },
            url: u.getUrl('stopCamp', urlParams),
            content: action.stopCamp,
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'stopCamp'
                            }
                        }
                    }
                }
            ]
        });

        action.campUnarc && !isSuperreader && result.push({
            block: 'link',
            mods: {
                theme: 'dark-blue'
            },
            url: u.getUrl('campUnarc', this.extend(urlParams, {
                tab: form.tab
            })),
            content: action.campUnarc,
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'unarchive'
                            }
                        }
                    }
                }
            ]
        });

        !paction.serviced && !paction.other_manager_serviced &&
                !paction.agency_serviced && paction.offerServicing && rights.UseOfferToServicing &&
                !(rights.manager_control && !rights.is_superteamleader && !this.isMyClient) &&
                !(rights.manager_control && !rights.is_superteamleader &&
                    (this.pageName == 'search' || this.pageName == 'search-for-agency')) && linkDang.push({

                        block: 'link',
                        mods: {
                            theme: 'dark-blue'
                        },
                        mix: [
                            {
                                block: 'b-campaigns-list-item',
                                elem: 'action',
                                elemMods: {
                                    type: 'offer-servicing'
                                }
                            },
                            {
                                block: 'b-metrika2',
                                js: {
                                    nativeEvent: 'click',
                                    params: {
                                        showCamps: {
                                            itemLink: 'offerServicing'
                                        }
                                    }
                                }
                            }
                        ],
                        url: u.getUrl('offerToServicing', urlParams),
                        content: paction.offerServicing
                    });

        (!hasLoginRights('is_any_client', 'agency_control')) && result.push({
            block: 'link',
            mods: {
                theme: 'dark-blue'
            },
            target: '_blank',
            url: u.moderation.getCampaignModerationUrl(data.is_production, camp.cid),
            content: iget2('b-campaigns-list-item', 'moderaciya', 'Модерация'),
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'moderate'
                            }
                        }
                    }
                }
            ]
        });

        camp.mediaType !== 'cpm_price' && !u.campaign.isInternal(camp.mediaType) && camp.strategy.net &&
            (/^(autobudget_avg_cpc|autobudget_avg_cpa)_per_(camp|filter)$/.test(camp.strategy.net.name) ||
                camp.autobudget != 'Yes') && camp.archived == 'No' &&
                (camp.allow_edit_camp || hasLoginRights('superreader_control', 'limited_support_control')) && result.push({
                    block: 'b-offline-set-phrases-prices',
                    mods: {
                        multi: 'yes'
                    },
                    js: {
                        id: ({
                            dynamic: 'b-offline-set-phrases-prices-dynamic-groups',
                            performance: 'b-offline-set-phrases-prices-performance',
                            cpm_banner: 'b-offline-set-phrases-prices-cpm-banner',
                            cpm_yndx_frontpage: 'b-offline-set-phrases-prices-cpm-yndx-frontpage',
                            cpm_deals: 'b-offline-set-phrases-prices-cpm-deals',
                            content_promotion: 'b-offline-set-phrases-prices-content-promotion',
                            mcbanner: 'b-offline-set-phrases-prices-mcbanner'
                        })[camp.mediaType] || 'b-offline-set-phrases-prices',
                        readonly: this.pageParams.readonly
                    },
                    content: {
                        block: 'button',
                        mods: {
                            size: 'xs',
                            pseudo: 'yes',
                            theme: 'normal'
                        },
                        mix: [{
                            block: 'b-offline-set-phrases-prices',
                            elem: 'toggle',
                            js: {
                                modelParams: this.ctx.modelParams
                            }
                        }],
                        content: iget2('b-campaigns-list-item', 'bid', 'Ставка')
                    }
                });
    }

    (this.pageName === 'search' || this.pageName == 'search-for-agency') &&
        (rights.super_control || rights.support_control) && result.push({

            block: 'link',
            mods: {
                theme: 'dark-blue'
            },
            target: '_blank',
            url: u.formatUrl({
                host: 'http://otrs.yandex-team.ru',
                path: 'search',
                query: {
                    X_OTRS_Login: camp.login || data.user_login,
                    QueueID: '2475_2492*_2311_2804*'
                }
            }),
            content: iget2('b-campaigns-list-item', 'tickets', 'Tickets'),
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'tickets'
                            }
                        }
                    }
                }
            ]
        });

    this.pageName === 'search' && (
            isSuperreader || rights.super_control || rights.support_control ||
            rights.is_superteamleader || rights.is_teamleader || rights.manager_control) && result.push({
                block: 'link',
                mods: {
                    theme: 'dark-blue'
                },
                target: '_blank',
                url: u.getUrl('showLogs', this.extend(urlParams, (function(today) {
                    return {
                        type: 'cmd',
                        date_to: today,
                        date_from: today
                    };
                })(u.moment().format('YYYY.MM.DD')))),
                content: iget2('b-campaigns-list-item', 'logi', 'Логи'),
                mix: [
                    {
                        block: 'b-metrika2',
                        js: {
                            nativeEvent: 'click',
                            params: {
                                showCamps: {
                                    itemLink: 'logs'
                                }
                            }
                        }
                    }
                ]
            });

    if (!camp.noaction && data.use_camp_description) {
        campDesc && (jsParamsForDesc.text = campDesc);

        this.withSearch && (jsParamsForDesc.index = this.ctx.index);

        linkDang.push({
            block: 'button',
            mods: {
                size: 'xs',
                pseudo: 'yes',
                theme: 'normal'
            },
            mix: [{
                block: 'b-campaigns-list',
                elem: 'desc',
                elemMods: campDesc ? '' : {
                    empty: 'yes'
                },
                js: jsParamsForDesc
            }],
            content: iget2('b-campaigns-list-item', 'primechaniya', 'Примечания')
        });
    }

    linkDang && !u.campaign.isInternal(camp.mediaType) && result.push({
        elem: 'actions-link-dang',
        content: u.spacer(linkDang, '&nbsp;&nbsp;')
    });

    return u.spacer(result, '&nbsp;&nbsp;');
});
