block('b-campaigns-list-item').elem('info')(

    def()(function() {
        return this.data.FORM.tab == 'arch' ? '' : applyNext();
    }),

    content()(function() {
        var data = this.data,
            camp = this.camp,
            rights = data.login_rights,
            paction = camp && camp.paction,
            managerInfo = paction && paction.other_manager_serviced_info,
            agencyInfo = paction && paction.agency_serviced_info,
            agencyRepsInfo = paction && paction.agency_serviced_lim_reps_info || [],
            showOriginalSumDebugInfo = data.FORM.debug &&
            hasLoginRights('support_control', 'is_developer', 'super_control'),
            info = [],
            infoItem;

        if (managerInfo) {
            infoItem = {
                label: iget2('b-campaigns-list-item', 'menedzher-123', 'Менеджер:')
            };

            if (data.UID == managerInfo.uid) {
                infoItem.value = this.addToSearch(iget2('b-campaigns-list-item', 'vy', 'вы'));
            } else if (rights.super_control || rights.placer_control) {
                infoItem.url = u.getUrl('showManagerMyClients', {
                    ulogin: camp.paction.other_manager_serviced_info.login
                });
                infoItem.value = [
                    this.addToSearch(managerInfo.FIO),
                    ' (',
                    this.addToSearch(managerInfo.login),
                    ')'
                ];
            } else {
                infoItem.url = 'mailto:' + managerInfo.email;
                infoItem.value = rights.is_any_client ? [
                    this.addToSearch(managerInfo.FIO),
                    ' &lt;',
                    this.addToSearch(managerInfo.email),
                    '&gt'
                ] : [
                    this.addToSearch(managerInfo.FIO),
                    ' (',
                    this.addToSearch(managerInfo.login),
                    ')'
                ];
            }

            info.push(infoItem);
        }

        if (agencyInfo && !rights.agency_control) {
            infoItem = {
                label: iget2('b-campaigns-list-item', 'predstavitel-agentstva', 'Представитель агентства:')
            };

            if (data.UID == agencyInfo.uid) {
                infoItem.value = this.addToSearch(iget2('b-campaigns-list-item', 'vy', 'вы'));
            } else {
                if (agencyRepsInfo.length >= 0) {
                    infoItem.subItems = agencyRepsInfo.map(function(repInfo) {
                        return {
                            url: 'mailto:' + repInfo.email,
                            value: rights.is_any_client ? [
                                this.addToSearch(u.escapeHTML(repInfo.FIO)),
                                ' &lt;',
                                this.addToSearch(repInfo.email),
                                '&gt'
                            ] : [
                                this.addToSearch(u.escapeHTML(repInfo.FIO)),
                                ' (',
                                this.addToSearch(repInfo.login),
                                ')'
                            ]
                        };
                    }.bind(this));
                }

                infoItem.url = 'mailto:' + agencyInfo.email;
                infoItem.value = rights.is_any_client ? [
                    this.addToSearch(u.escapeHTML(agencyInfo.FIO)),
                    ' &lt;',
                    this.addToSearch(agencyInfo.email),
                    '&gt'
                ] : [
                    this.addToSearch(u.escapeHTML(agencyInfo.FIO)),
                    ' (',
                    this.addToSearch(agencyInfo.login),
                    ')'
                ];
            }

            info.push(infoItem);
        }

        this.can.show_emails && camp.email && info.push({
            label: 'Email:',
            url: 'mailto:' + camp.email,
            value: this.addToSearch(camp.email)
        });

        (rights.AdmSendBKMD || rights.is_developer) && info.push({
            value: iget2('b-campaigns-list-item', 'pereotpravit-v-bk', 'Переотправить в БК'),
            url: u.getUrl('admSendBK', {
                cid: camp.cid,
                ulogin: camp.login
            })
        });

        rights.super_control && data.CONFIGURATION != 'production' && info.push({
            value: iget2('b-campaigns-list-item', 'modifikaciya-testovoy-bd', 'Модификация тестовой БД'),
            url: u.getUrl('fakeadmCamp', {
                cid: camp.cid
            })
        }, {
            value: iget2('b-campaigns-list-item', 'prosmotr-parametrov-kampanii', 'Просмотр параметров кампании'),
            url: u.getUrl('showCampSettings', {
                cid: camp.cid,
                ulogin: camp.login
            })
        });

        showOriginalSumDebugInfo && info.push({
            value: 'original_sum: ' + camp.original_sum +
                ', original_sum_spent: ' + camp.original_sum_spent,
            mods: {
                type: 'original-sum-info'
            }
        });

        return info.map(function(infoItem) {
            var content = infoItem.label ? [{
                elem: 'info-dt',
                content: infoItem.label
            }] : [];

            if (infoItem.subItems && infoItem.subItems.length) {
                var subItemsContent = infoItem.subItems.map(function(item) {
                    if (item.url) {
                        return {
                            block: 'link',
                            mods: {
                                theme: 'dark-blue'
                            },
                            url: item.url,
                            content: item.value,
                            mix: [
                                {
                                    block: 'b-metrika2',
                                    js: {
                                        nativeEvent: 'click',
                                        params: {
                                            showCamps: {
                                                itemLink: item.url.indexOf('mailto') !== -1 ? 'mail' : item.url
                                            }
                                        }
                                    }
                                }
                            ]
                        };
                    } else {
                        return item.value;
                    }
                });

                content.push({
                    elem: 'info-dd',
                    elemMods: infoItem.mods,
                    content: u.spacer2(subItemsContent, ', ')
                });
            } else {
                content.push({
                    elem: 'info-dd',
                    elemMods: infoItem.mods,
                    content: infoItem.url ?
                        {
                            block: 'link',
                            mods: {
                                theme: 'dark-blue'
                            },
                            url: infoItem.url,
                            content: infoItem.value,
                            mix: [
                                {
                                    block: 'b-metrika2',
                                    js: {
                                        nativeEvent: 'click',
                                        params: {
                                            showCamps: {
                                                itemLink: infoItem.url.indexOf('mailto') !== -1 ? 'mail' : infoItem.url
                                            }
                                        }
                                    }
                                }
                            ]
                        } :
                    infoItem.value
                });
            }

            return {
                elem: 'info-dl',
                content: content
            };
        });
    })
);
