block('b-campaigns-list-item').elem('pay')(
    addMix()(function() {
        var iglueMix = [{
            block: 'i-glue',
            js: {
                modelName: u.campaign.getCampaignModelName(this.camp.mediaType),
                modelId: this.camp.cid
            }
        }];

        return this.ctx.mix ? this.ctx.mix.concat(iglueMix) : iglueMix;
    }),

    content()(function() {
        var data = this.data,
            camp = this.camp,
            form = data.FORM,
            fname = 'oldsum_' + camp.cid,
            value = data.oldsum && data.oldsum[camp.cid] || form[fname];

        return {
            block: 'input',
            mix: [
                {
                    block: 'b-campaigns-list-item',
                    elem: 'pay-value'
                },
                {
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'sumInput',
                        type: 'validated-input'
                    }
                }
            ],
            name: fname,
            mods: {
                clear: 'no',
                autocomplete: 'off'
            },
            value: value && u.round2s(value) || '',
            content: {
                elem: 'control'
            }
        };
    })
);
