block('b-campaigns-list-item').elem('settings').content()(function() {
    var data = this.data,
        camp = this.camp,
        isCpmStrategy = u.campaign.isCpm(camp.mediaType),
        sortSettings = this.sortSettings.arr,
        form = data.FORM,
        strategy = typeof camp.strategy === 'string' ?
        {
            name: camp.strategy,
            search: {
                name: camp.strategy
            },
            net: {
                // cpm стратегий (только в сетях)
                name: isCpmStrategy ? camp.strategy_name : camp.strategy
            }
        } :
        camp.strategy || {},
        isDiffPlaces = strategy.name === 'different_places',
        isMobileContent = camp.mediaType === 'mobile_content',
        showYacontext = camp.dontShowYacontext === 'No',
        settingsConditions = {
            dontShowYacontext: showYacontext, // неправильный ключ, означает поиск в "сетях"
            broad_match_flag: !isMobileContent && camp.broad_match_flag === 'Yes',
            statusOpenStat: !isMobileContent && camp.statusOpenStat === 1,
            sDefault: !isDiffPlaces && strategy.search && strategy.search.name === 'default' ||
                strategy.net && strategy.net.name === 'cpm_default',
            sMinprice: !isDiffPlaces && strategy.search && strategy.search.name === 'min_price',
            sOptimizeClicksWeekBudget: !isDiffPlaces && strategy.search && strategy.search.name === 'autobudget' && strategy.search.goal_id === null,
            sOptimizeClicksWeekBundle: !isDiffPlaces && strategy.search && strategy.search.name === 'autobudget_week_bundle',
            sOptimizeClicksAvgClick: !isDiffPlaces && strategy.search && strategy.search.name === 'autobudget_avg_click',
            sOptimizeCpaWeekBudget: !isDiffPlaces && strategy.search && strategy.search.name === 'autobudget' && strategy.search.goal_id !== null,
            sOptimizeCpaAvgCpa: !isDiffPlaces && strategy.search && strategy.search.name === 'autobudget_avg_cpa',
            sAutobudgetRoi: !isDiffPlaces && strategy.search && strategy.search.name === 'autobudget_roi',
            sAutobudgetAvgCPCPerCamp: (!isDiffPlaces && strategy.name === 'autobudget_avg_cpc_per_camp') ||
                (camp.mediaType === 'mcbanner' && strategy.search.name === 'autobudget_avg_cpc_per_camp'),
            sAutobudgetAvgCPCPerFilter: !isDiffPlaces && strategy.name === 'autobudget_avg_cpc_per_filter',
            sAutobudgetAvgCPAPerCamp: !isDiffPlaces && strategy.name === 'autobudget_avg_cpa_per_camp',
            sAutobudgetAvgCPAPerFilter: !isDiffPlaces && strategy.name === 'autobudget_avg_cpa_per_filter',
            sAutobudgetMaxReach: strategy.net && strategy.net.name === 'autobudget_max_reach',
            sAutobudgetAvgCpv: strategy.net && strategy.net.name === 'autobudget_avg_cpv',
            sAutobudgetAvgCpvCustomPeriod: strategy.net && strategy.net.name === 'autobudget_avg_cpv_custom_period',
            sAutobudgetMaxReachCustomPeriod: strategy.net && strategy.net.name === 'autobudget_max_reach_custom_period',
            sAutobudgetMaxImpressions: strategy.net && strategy.net.name === 'autobudget_max_impressions',
            sAutobudgetMaxImpressionsCustomPeriod: strategy.net &&
                strategy.net.name === 'autobudget_max_impressions_custom_period',
            sPeriodFixBid: strategy.net &&
                strategy.net.name === 'period_fix_bid',
            sDifferentPlaces: isDiffPlaces,
            statusMetricaControl: camp.statusMetricaControl === 'Yes',
            DontShow: camp.DontShowDefined == '1',
            disabledIps: camp.disabledIpsDefined == '1'
        },
        isDisable,
        isHighlight,
        result = [];

    function prepareText(value, text) {
        var isChangeManualStrategyName = Boolean(data.has_change_name_bid_optimization);

        var isCampaignTypeMedia = camp.mediaType === 'cpm_banner' ||
            camp.mediaType === 'cpm_deals' ||
            camp.mediaType === 'cpm_yndx_frontpage';

        var overrideText = text;

        if (!isChangeManualStrategyName && (!showYacontext || isCampaignTypeMedia)) {
            overrideText = iget2('b-campaigns-list-item', 'manual-strategy-net3', 'Ручное управление');
        } else if (isChangeManualStrategyName && isCampaignTypeMedia) {
            overrideText = iget2('b-campaigns-list-item', 'manual-strategy-net3', 'Ручное управление')
        }

        switch (value) {
            case 'sDefault':
                return overrideText;
            default:
                return text;
        }
    }

    sortSettings.forEach(function(setting) {
        isDisable = !settingsConditions[setting.value];
        isHighlight = form.sort === 'settings' && form.settings_sorted === setting.value;

        !(setting.isAbsent && !isHighlight || setting.isAbsentSoft && isDisable) && result.push({
            elem: 'setting',
            elemMods: {
                disabled: isDisable ? 'yes' : '',
                highlighted: isHighlight ? 'yes' : ''
            },
            content: {
                elem: 'setting-title',
                content: prepareText(setting.value, setting.title)
            }
        });
    });

    return result;
});
