block('b-campaigns-list-item').elem('title').content()(function() {
    var data = this.data,
        rights = data.login_rights,
        experiments = data.experiments,
        camp = this.camp,
        action = camp.action,
        paction = camp.paction,
        urlParams = {},
        title,
        tick,
        sup,
        serviceManager,
        more = [],
        mediaplanLink,
        hasUnresolvedMediaplan = camp.has_mediaplan_banners == '1' && camp.mediaplan_status == 'Complete',
        optimizedReady = camp.optimized_status == 'Ready',
        name = this.addToSearch(u.escapeHTML(camp.name));

    if (action && action.Lookup) {
        urlParams = {
            cid: camp.cid,
            ulogin: this.can.showuid ? camp.login : ''
        };
        optimizedReady && (urlParams.tab = 'media');

        title = {
            block: 'link',
            url: u.getUrl(optimizedReady ? 'showMediaplan' : 'showCamp', urlParams),
            content: name
        };
    } else {
        title = action && action.campUnarc ?
            name : [
                {
                    block: 'icon',
                    mods: {
                        'size-12': 'lock'
                    }
                },
                name
            ];
    }

    more.push([
        '№&nbsp;',
        this.addToSearch(camp.cid)
    ]);

    +camp.OrderID && (rights.placer_control || rights.super_control || rights.support_control ||
        rights.superreader_control || rights.placer_control) && more.push({
            block: 'link',
            target: '_blank',
            url: u.formatUrl({
                host: 'https://lookup-profile-caesar1.n.yandex-team.ru',
                path: 'lookup_profile/Orders',
                query: {
                    OrderID: camp.OrderID
                }
            }),
            content: iget2('b-campaigns-list-item', 'bk-144', 'БК') + ':&nbsp;' + camp.OrderID,
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'bk'
                            }
                        }
                    }
                }
            ]
        });

    rights.is_internal_user && more.push({
        block: 'link',
        target: '_blank',
        url: u.formatUrl({
            host: 'https://crm.yandex-team.ru',
            path: 'client.aspx',
            query: {
                id: camp.ClientID
            }
        }),
        content: 'CRM',
        mix: [
            {
                block: 'b-metrika2',
                js: {
                    nativeEvent: 'click',
                    params: {
                        showCamps: {
                            itemLink: 'crm'
                        }
                    }
                }
            }
        ]
    });

    camp.experiment_id && more.push({
        block: 'b-experiment-mark',
        experiment: experiments[camp.experiment_id],
        hasActions: hasLoginRights('super_control', 'manager_control')
    });

    paction && paction.AcceptServicing && (serviceManager = {
        elem: 'title-accept',
        content: '-&nbsp;' + paction.AcceptServicing
    });

    !!+camp.is_new_optimizing_request && camp.optimized && optimizedReady && (tick = {
        elem: 'mediaplan-link',
        urlParams: urlParams
    });

    !!+camp.is_new_mediaplan && hasUnresolvedMediaplan && (mediaplanLink = {
        elem: 'mediaplan-link',
        urlParams: urlParams
    });

    return [
        title,
        ' (',
        u.spacer(more, '&nbsp; '),
        ')',
        serviceManager,
        tick,
        sup,
        mediaplanLink
    ];
});
