/**
 * Блок кампании в списке кампаний
 * @param {Object} modelParams параметры модели данной кампании
 * @private
 */
block('b-campaigns-list-item')(

    match(function() {
        return !this.withSearch;
    }).def()(function() {
        return applyNext({
            addToSearch: function(text) {
                return text;
            }
        });
    }),

    match(function() {
        return this.withSearch;
    }).def()(function() {
        var newIndex = this.searchIndex.length,
            addToSearch = function(text) {
                this.searchIndex[newIndex] += text.toLowerCase() + '\n';

                return {
                    block: 'b-campaigns-list',
                    elem: 'hlt',
                    content: text
                };
            };

        this.searchIndex[newIndex] = '';

        return applyNext({
            addToSearch: addToSearch
        });
    }),

    match(function() {
        return !this.camp;
    }).def()(function() {
        var data = this.data,
            oldsum = data.oldsum || {},
            form = data.FORM,
            camp = this.ctx.camp,
            cid = camp.cid,
            mods = {},
            canPay = camp.lowMonthShowsNoPay || camp.product_type != 'mcb_pkg',
            searchStrategy,
            netStrategy;

        //на поиске кампаний по имени клиента не приходит нормальный хэш со стратегиями
        camp.strategy = camp.strategy || 0;
        searchStrategy = camp.strategy.search ? camp.strategy.search.name : camp.strategy;
        netStrategy = camp.strategy.net ? camp.strategy.net.name : '';

        delete this.ctx.camp;

        (!camp.wallet_is_enabled && !+camp.wallet_total) &&
        ((+camp.total <= 0 && typeof camp.total != 'undefined') || !(camp.action && camp.action.Lookup)) &&
        camp.archived != 'Yes' && (mods.disabled = 'yes');

        (oldsum[cid] || form['oldsum_' + cid]) && (mods.init = 'force');

        return applyNext({
            camp: camp,
            campCanPay: canPay,
            weekBudgetRestriction: searchStrategy && searchStrategy.indexOf('autobudget') != -1 ||
                netStrategy && netStrategy.indexOf('autobudget') != -1 ||
                    camp.strategy.name == 'different_places' && camp.strategy.is_search_stop &&
                        (netStrategy && netStrategy.indexOf('autobudget') != -1),
            isWeekBundle: (searchStrategy == 'autobudget_week_bundle' ||
                camp.strategy.name == 'different_places' && camp.strategy.is_search_stop &&
                (netStrategy == 'autobudget_week_bundle')),
            isPeriodBudget: (camp.strategy.net || {}).name === 'autobudget_max_impressions_custom_period' ||
                (camp.strategy.net || {}).name === 'autobudget_max_reach_custom_period' ||
                (camp.strategy.net || {}).name === 'autobudget_avg_cpv_custom_period',
            'ctx.mods': mods
        });
    }),

    addJs()(function() {
        return {
            cid: this.camp.cid,
            modelParams: this.ctx.modelParams
        };
    }),

    addMix()(function() {
        return [
            {
                block: 'b-campaigns-list',
                elem: 'row',
                elemMods: this.camp._isHide ? { hidden: 'yes' } : {}
            },
            {
                block: 'b-style-table',
                elem: 'row'
            },
            {
                block: 'b-metrika2',
                js: {
                    event: 'delete-click',
                    params: {
                        ShowCamps: {
                            Delete: {
                                Message: 'Yes'
                            }
                        }
                    },
                    blockName: 'b-campaigns-list-item'
                }
            }
        ];
    }),

    content()(function() {
        var data = this.data,
            result = [],
            camp = this.camp,
            form = data.FORM,
            numericalColumns,
            action = camp.action || {},
            index = this.ctx.index,
            showWalletColumn = this.ctx.showWalletColumn,
            isWalletDisabled = this.ctx.isWalletDisabled,
            can = this.can,
            tableNum = this.ctx.tableNum,
            strategy = camp.strategy || {},
            commonWallet = {};

        if (data.wallet) {
            commonWallet = +camp.AgencyID ? data.wallet.agencies[camp.AgencyID] : data.wallet.self;
        }

        can.multiedit && result.push({
            block: 'checkbox',
            checkboxAttrs: {
                autocomplete: 'off'
            },
            mix: [{
                block: 'b-checkboxes-group',
                elem: 'item'
            }]
        });

        result.push({
            block: 'b-campaigns-list-item',
            elem: 'number-wrapper',
            content: [
                {
                    block: 'b-campaigns-list-item',
                    elem: 'number',
                    mix: [{
                        block: 'b-campaigns-list',
                        elem: 'number'
                    }],
                    content: tableNum
                },
                camp.mediaType === 'mobile_content' && {
                    block: 'b-icon',
                    mix: {
                        block: 'b-campaigns-list-item',
                        elem: 'mobile-content-icon'
                    },
                    mods: {
                        'size-16': 'mobile-content'
                    }
                }
            ]
        });

        result.push([

            {
                block: 'b-campaigns-list-item',
                elem: 'title',
                elemMods: !action.Lookup && !action.campUnarc ? { lockes: 'yes' } : ''
            },
            {
                block: 'b-campaigns-list-item',
                elem: 'actions',
                modelParams: this.ctx.modelParams,
                index: index
            },
            this.camp.freelancer_info && {
                block: 'b-campaigns-list-item',
                elem: 'freelancer-info',
                content: [
                    {
                        elem: 'freelancer-info-label',
                        content: [
                            iget2('b-campaigns-list-item', 'frilancer', 'Специалист'),
                            ':&nbsp'
                        ],
                    },
                    this.camp.freelancer_info.FIO || '',
                    '&nbsp(',
                    this.camp.freelancer_info.login || '',
                    ')'
                ]
            },
            {
                block: 'b-campaigns-list-item',
                elem: 'info'
            }
        ]);

        result.push({
            block: 'b-campaigns-list-item',
            elem: 'settings'
        });

        can.see_owner && result.push({
            block: 'link',
            title: u.escapeHTML(camp.user_fio),
            url: u.getUrl('showCamps', {
                ulogin: camp.login
            }),
            content: camp.login,
            mix: [
                {
                    block: 'b-metrika2',
                    js: {
                        nativeEvent: 'click',
                        params: {
                            showCamps: {
                                itemLink: 'owner'
                            }
                        }
                    }
                }
            ]
        });

        result.push({
            block: 'b-campaigns-list-item',
            elem: 'state'
        }, {
            block: 'b-campaigns-list-item',
            elem: 'date'
        });

        numericalColumns = showWalletColumn ?
            ['clicks'] :
            form.tab === 'arch' ?
                ['sum', 'clicks'] :
                ['clicks', 'sum'];
        (data.can.see_original_sum || isWalletDisabled) || (numericalColumns = numericalColumns.slice(0, 1));

        !showWalletColumn && numericalColumns.push('sum-rest');

        result = result.concat(numericalColumns.map(function(numerical) {

            // DIRECT-49446 - показываем просто сумму без ссылки для столбца "Было" обычным пользователям
            if (numerical === 'sum' &&
                !hasLoginRights('manager_control', 'super_control', 'placer_control', 'support_control')) {

                return {
                    block: 'b-list-numeric',
                    content: u.formatShowsOrMoney(camp._totals[numerical], 'money')
                };
            }

            return {
                block: 'b-list-numeric',
                mods: {
                    type: numerical
                },
                camp: camp,
                content: camp._totals[numerical]
            };
        }, this));

        !this.currency && result.push({
            block: 'b-campaigns-list-item',
            elem: 'currency',
            content: u.currencies.getName(camp.currency)
        });

        !showWalletColumn && data.can.showPayColumn && result.push(can.showPayColumn && action.pay && !camp.noaction ?
            {
                block: 'b-campaigns-list-item',
                elem: 'pay',
                camp: camp
            } :
            '');

        can.process_money_common && showWalletColumn && result.push({
            block: 'b-campaigns-list-item',
            elem: 'wallet',
            attrs: {
                colspan: data.can.showPayColumn ?
                    data.can.see_original_sum ? 3 : 2 : data.can.see_original_sum ? 2 : 1
            },
            content: camp.mediaType !== 'cpm_price' && camp.wallet_is_enabled ?
                [
                    {
                        block: 'b-wallet-day-budget',
                        modelParams: this.ctx.modelParams,
                        mods: {
                            editable: this.weekBudgetRestriction ? '' : 'yes',
                            warning: camp.day_budget && +camp.day_budget.sum && +camp.day_budget.sum <
                                camp.day_budget.recommended_sum ?
                                    'yes' :
                                    ''
                        },
                        mix: {
                            block: 'b-metrika2',
                            js: {
                                event: 'save-click',
                                params: {
                                    ShowCamps: {
                                        Daily: {
                                            Popup: 'Choose'
                                        }
                                    }
                                },
                                blockName: 'b-wallet-day-budget'
                            }
                        },
                        isWeekBundle: this.isWeekBundle,
                        isPeriodBudget: this.isPeriodBudget,
                        weekBudgetRestriction: this.weekBudgetRestriction,
                        cid: camp.cid,
                        action: camp.action,
                        autobudgetSum: strategy.search.sum || strategy.net.sum || strategy.net.budget,
                        dayBudget: camp.day_budget2,
                        commonWalletDayBudget: commonWallet.day_budget,
                        currency: commonWallet.currency
                    },
                    (commonWallet.day_budget || {}).sum > 0 && {
                        elem: 'common-wallet-notice',
                        content: iget2(
                            'b-campaigns-list-item',
                            'ustanovleno-orgranichenie-br-na',
                            'установлено ограничение<br/>на дневной бюджет для общего счёта'
                        )
                    },
                    {
                        elem: 'cpm-period',
                        strategy: camp.strategy
                    }
                ] :
                ''
        });

        return result.map(function(item) {
            return item.cellMods ?
                {
                    block: 'b-campaigns-list',
                    elem: 'cell',
                    elemMods: item.cellMods,
                    content: item.cellContent
                } :
                {
                    block: 'b-campaigns-list',
                    elem: 'cell',
                    attrs: item.attrs,
                    content: item
                };
        });
    })
);
