(function() {

    var blocks = BEM.blocks,
        bConfirm = blocks['b-confirm'];

    /**
     *
     * @event b-campaigns-list-item#delete-click Удалить компанию - клик на кнопке "удалить"
     *
     * @fires b-campaigns-list-item#delete-click
     */
    BEM.DOM.decl('b-campaigns-list-item', {
        onSetMod: {
            js: function() {
                this.campaign = BEM.MODEL.getOne(this.params.modelParams);
            }
        },

        /**
         * Обработчик клика по ссылке-действию
         * @private
         * @param {jQuery.Event} e
         */
        _onClickAction: function(e) {
            var modVal = this.getMod(e.data.domElem, 'type');

            if (modVal == 'delete') {
                this._onDeleteItem(e);
                e.preventDefault();
            }
        },

        /**
         * Обработчик клика по ссылке 'Удалить'
         * @param {jQuery.Event} e
         * @private
         */
        _onDeleteItem: function(e) {
            this.trigger('delete-click');
            bConfirm.open({
                limited: true,
                message: iget2('b-campaigns-list-item', 'vy-uvereny-chto-hotite', 'Вы уверены, что хотите удалить кампанию?'),
                fromLink: e.data.domElem
            });
        },

        /**
         * @private
         * @type {Object}
         */
        _params: null,

        /**
         * Возвращает cid из js-параметров
         * @returns {Number}
         */
        getCid: function() {
            return this.campaign.get('cid');
        },

        /**
         * @type {String}
         * @private
         */
        _currency: null,

        /**
         * Возвращает валюту кампании
         * @returns {String}
         * @private
         */
        _getCurrency: function() {
            return this._currency || (this._currency =
                this.campaign.get('currency'));
        },

        /**
         * @type {String}
         * @private
         */
        _groupId: null,

        /**
        * @type {BEM}
        * @private
        */
        _input: null,

        /**
         * Возвращает инпут
         * @returns {BEM}
         * @private
         */
        _getInput: function() {
            return this._input || (this._input = this.findBlockOn('pay-value', 'input'));
        },

        /**
         * Очищает значение инпута
         */
        clearValue: function() {
            this._getInput().val('', { corrected: 'yes' });
        },

        /**
         * Устанавливает фокус на инпуте
         */
        focusInput: function() {
            this._getInput().setMod('focused', 'yes');
        },

        /**
         * Отображает тултип с подсказкой
         * @param {Event} e
         * @private
         */
        _showTooltipCpmPeriod: function(e) {
            this._tipman || (this._tipman = BEM.create('tipman', {
                tipMods: { theme: 'white', size: 's', target: 'anchor' },
                tipMix: { block: 'b-campaigns-list-item', elem: 'cpm-period-tooltip' },
                popupDirections: ['bottom-right']
            }));

            this._tipman.show({
                owner: e.data.domElem,
                content: iget2('i-utils', 'strategy-cpm-period-expired', 'Период действия стратегии завершился.<br/>Задайте новые настройки стратегии')
            });
        },

        /**
         * Обработчик событий pointerover pointerout на элементе ошибки
         * @param {jQuery.Event} e
         * @private
         */
        _onMouseOver: function(e) {
            if (e.type === 'pointerover') {
                this._showTooltipCpmPeriod(e);
            } else {
                this._tipman && this._tipman.hide();
            }
        }

    }, {
        live: function() {
            this
                .liveBindTo('action', 'pointerclick', function(e) {
                    this._onClickAction(e);
                })
                .liveBindTo('cpm-period-alert', 'pointerover pointerout', function(e) {
                    this._onMouseOver(e);
                });
        }
    });
})();
