block('b-campaigns-list').elem('form-pay')(

    addJs()(function() {
        return {
            action: this.data.SCRIPT,
            params: apply('hiddenParams')
        };
    }),

    mode('hiddenParams')(function() {
        var data = this.data,
            uidPar = data.uid_par,
            currency = this.currency,
            params = {
                cmd: 'payforall',
                money_type: 1
            };

        currency && (params['currency'] = currency);

        uidPar && (params[uidPar.key] = uidPar.value);

        return params;
    }),

    match(function() {
        return this.data.cmd == 'showCamps';
    }).mode('hiddenParams')(function() {
        return this.extend(applyNext(), {
            tab: this.data.FORM.tab
        });
    }),

    match(function() {
        return this.data.cmd == 'showSubClientCamps';
    }).mode('hiddenParams')(function() {
        var data = this.data,
            form = data.FORM,
            paramsSubClient = {
                multiuser: 'true',
                rcmd: form.cmd,
                client_login: form.client_login
            };

        data.onpage && (paramsSubClient.onpage = data.onpage);

        return this.extend(applyNext(), paramsSubClient);
    }),

    content()(function() {
        return {
            block: 'button',
            mix: [
                {
                    block: 'b-campaigns-list',
                    elem: 'button-pay'
                },
                {
                    block: 'b-metrika2',
                    js: {
                        event: 'click',
                        blockName: 'button',
                        params: {
                            showCamps: 'payButtonClicked'
                        }
                    }
                }
            ],
            mods: {
                disabled: 'yes'
            },
            tabindex: 1,
            content: u.currencies.getText(this.currency, 'pay_in')
        };
    }),

    match(function() {
        return this.data.show_yamoney_button;
    }).content()(function() {
        return [
            {
                block: 'button',
                mix: [
                    {
                        block: 'b-campaigns-list',
                        elem: 'button-pay',
                        elemMods: {
                            money: 'yandex',
                            visibility: 'hidden'
                        }
                    },
                    {
                        block: 'b-metrika2',
                        js: {
                            event: 'click',
                            blockName: 'button',
                            params: {
                                showCamps: 'yandexMoneyPayButtonClicked'
                            }
                        }
                    }
                ],
                mods: {
                    disabled: 'yes'
                },
                tabindex: 2,
                content: iget2('b-campaigns-list', 'oplatit-yandeks-dengami', 'Оплатить Яндекс.Деньгами')
            },
            applyNext()
        ];
    })
);
