block('b-campaigns-list').elem('group')(

    match(function() {
        return this.ctx.group._isHideGroup;
    }).def()(function() {
        this.ctx.mods = {
            hidden: 'yes'
        };
        delete this.ctx.group._isHideGroup;

        return applyNext();
    }),

    addJs()(function() {
        var from = this.searchIndex.length;

        return {
            from: from,
            to: from + this.ctx.group.camps.length
        };
    }),

    content()(function() {
        var group = this.ctx.group,
            result = [],
            //колонку про единый счет показываем только для страницы списка кампаний
            showWalletColumn = this.data.cmd === 'showCamps' ? group.camps[0].wallet_is_enabled : 0,
            isWalletDisabled = group.isWalletDisabled,
            campCounter = 0;

        this.campsGroupsKeys.length > 1 && group.title && result.push({
            block: 'b-campaigns-list',
            elem: 'group-title',
            content: [
                group.walletLink,
                {
                    elem: 'group-title-string',
                    content: group.title
                }
            ]
        });

        result.push({
            block: 'b-campaigns-list',
            elem: 'head',
            showWalletColumn: showWalletColumn,
            isWalletDisabled: isWalletDisabled
        });

        this.data.FORM.sort == 'settings' && result.push({
            block: 'b-campaigns-list',
            elem: 'sort'
        });

        result = result.concat(group.camps.map(function(camp, i) {
            !camp._isHide && campCounter++;

            return {
                block: 'b-campaigns-list-item',
                showWalletColumn: showWalletColumn,
                isWalletDisabled: isWalletDisabled,
                modelParams: {
                    id: camp.cid,
                    name: u.campaign.getCampaignModelName(camp.mediaType)
                },
                camp: camp,
                index: i,
                tableNum: campCounter
            };
        }));

        result.push({
            block: 'b-campaigns-list',
            elem: 'total',
            elemMods: this.ctx.groupId && {
                'group-id': u.beminize(this.ctx.groupId)
            },
            showWalletColumn: showWalletColumn,
            campaigns: group.camps,
            total: group.total,
            isWalletDisabled: isWalletDisabled
        });

        return result;
    })
);
