block('b-campaigns-list').elem('head')(

    addMix()([{
        block: 'b-style-table',
        elem: 'head'
    }]),

    content()(function() {
        var result = [],
            data = this.data,
            form = data.FORM,
            can = this.can,
            currency = this.currency,
            formattedCurrency = currency ?
            u.currencies.getName(data.is_currency_archive ? 'YND_FIXED' : currency) :
            false,
            showWalletColumn = this.ctx.showWalletColumn,
            isWalletDisabled = this.ctx.isWalletDisabled;

        can.multiedit && result.push({
            content: {
                block: 'checkbox',
                checkboxAttrs: {
                    autocomplete: 'off'
                },
                mix: [{
                    block: 'b-checkboxes-group',
                    elem: 'item'
                }]
            }
        });

        result.push({
            elem: 'num'
        });

        result.push({
            elem: 'name',
            content: [
                {
                    block: 'b-sort-link',
                    col: 'name',
                    content: iget2('b-campaigns-list', 'nazvanie', 'Название')
                },
                ' / ',
                {
                    block: 'b-sort-link',
                    col: 'cid',
                    content: '&#8470;'
                }
            ]
        });

        result.push({
            elem: 'settings',
            content: {
                block: 'dropdown',
                mods: {
                    type: 'settings',
                    sorted: form.settings_sorted && (form.sort == 'settings') ? 'yes' : ''
                },
                content: [
                    {
                        block: 'button',
                        mix: [{
                            block: 'dropdown',
                            elem: 'switcher'
                        }],
                        mods: {
                            size: 'xs',
                            pseudo: 'yes',
                            theme: 'normal'
                        },
                        content: iget2('b-campaigns-list', 'parametry', 'Параметры')
                    },
                    {
                        block: 'b-sort-link',
                        mods: {
                            type: 'reset'
                        },
                        col: 'cid',
                        options: {
                            default_reverse: 0
                        }
                    },
                    {
                        elem: 'popup',
                        mix: [{
                            block: 'b-campaigns-settings',
                            js: true
                        }],
                        elemMods: { 'has-close': 'yes' },
                        content: {
                            block: 'b-campaigns-settings',
                            elem: 'content'
                        }
                    }
                ]
            }
        });

        can.see_owner && result.push({
            elem: 'owner',
            content: {
                block: 'b-sort-link',
                col: 'login',
                content: iget2('b-campaigns-list', 'vladelec', 'Владелец')
            }
        });

        result.push({
            elem: 'state',
            content: {
                block: 'b-sort-link',
                col: 'status.text',
                content: iget2('b-campaigns-list', 'sostoyanie', 'Состояние')
            }
        }, {
            elem: 'date',
            content: {
                block: 'b-sort-link',
                col: 'start_time',
                content: iget2('b-campaigns-list', 'nachalo', 'Начало')
            }
        });

        if (!showWalletColumn) {
            result.push({
                elem: 'numeric',
                content: form.tab == 'arch' ?
                    (formattedCurrency ?
                        iget2('b-campaigns-list', 'summa-s', 'Сумма, {foo}', {
                            foo: formattedCurrency
                        }) :
                        iget2('b-campaigns-list', 'summa', 'Сумма')) :
                    {
                        block: 'b-sort-link',
                        col: 'clicks',
                        options: {
                            default_reverse: 1
                        },
                        content: iget2('b-campaigns-list', 'klikov', 'Кликов')
                    }
            });

            (data.can.see_original_sum || isWalletDisabled) && result.push({
                elem: 'numeric',
                content: form.tab == 'arch' ?
                    iget2('b-campaigns-list', 'klikov', 'Кликов') : {
                        block: 'b-sort-link',
                        col: 'sum',
                        defaultCol: 'cid',
                        options: {
                            default_reverse: 1
                        },
                        content: formattedCurrency ? iget2('b-campaigns-list', 'bylo-s', 'Было, {foo}', {
                            foo: formattedCurrency
                        }) : iget2('b-campaigns-list', 'bylo', 'Было')
                    }
            });

            result.push({
                elem: 'numeric',
                content: {
                    block: 'b-sort-link',
                    col: 'total',
                    options: {
                        default_reverse: 1
                    },
                    content: formattedCurrency ? iget2('b-campaigns-list', 'ostalos-s-138', 'Осталось, {foo}', {
                        foo: formattedCurrency
                    }) : iget2('b-campaigns-list', 'ostalos', 'Осталось')
                }
            });
        } else {
            result.push({
                elem: 'numeric',
                content: {
                    block: 'b-sort-link',
                    col: 'clicks',
                    options: {
                        default_reverse: 1
                    },
                    content: iget2('b-campaigns-list', 'klikov', 'Кликов')
                }
            });
        }

        // для DIRECT-19889 добавляем колонку "Валюта" для случаев
        // когда в списке могут быть кампании в разных валютах
        formattedCurrency || result.push({
            elem: 'numeric',
            content: {
                block: 'b-sort-link',
                col: 'currency',
                options: {
                    default_reverse: 1
                },
                content: iget2('b-campaigns-list', 'valyuta', 'Валюта')
            }
        });

        !showWalletColumn && data.can.showPayColumn && result.push(can.showPayColumn ?
            {
                elem: 'numeric',
                elemMods: {
                    pay: 'yes'
                },
                content: iget2('b-campaigns-list', 'polozhit-dengi-s', 'Положить деньги, {foo}', {
                    foo: u.currencies.getName(currency)
                })
            } :
            '');

        can.process_money_common && showWalletColumn && result.push({
            elem: 'wallet',
            attrs: {
                colspan: data.can.showPayColumn ?
                    data.can.see_original_sum ? 3 : 2 : data.can.see_original_sum ? 2 : 1
            },
            content: formattedCurrency ? iget2('b-campaigns-list', 'ogranicheniya-byudzheta-s', 'Ограничения бюджета, {foo}', {
                foo: formattedCurrency
            }) : iget2('b-campaigns-list', 'ogranicheniya-byudzheta', 'Ограничения бюджета')
        });

        return result.map(function(td) {
            var content = td.content;

            delete td.content;
            td.elem && (td.block = 'b-campaigns-list');

            return {
                elem: 'cell',
                attrs: td.attrs,
                mix: [td],
                content: content
            };
        }, this);
    })
);
