block('b-campaigns-list').elem('table')(

    addJs()(function() {
        return {
            ignoredCamps: this.ignoredFavCamps
        };
    }),

    addMix()([{
        block: 'b-style-table',
        mods: {
            theme: 'gray-list'
        }
    }]),

    content()(function() {
        var showWalletColumnTotal = false,
            result = this.campsGroupsKeys.map(function(groupId) {
                var group = this.campsGroups[groupId];

                showWalletColumnTotal = showWalletColumnTotal ||
                    (this.data.cmd === 'showCamps' ? group.camps[0].wallet_is_enabled : 0);

                return {
                    block: 'b-campaigns-list',
                    elem: 'group',
                    mix: this.can.multiedit ? [{
                        block: 'b-checkboxes-group',
                        js: true,
                        mods: {
                            ignored: 'yes'
                        }
                    }] : false,
                    groupId: groupId.replace(/^\d*_/g, ''),
                    group: group
                };
            }, this);

        this.commonTotal && result.push({
            block: 'b-campaigns-list',
            elem: 'total',
            campaigns: this.ctx.campaigns,
            showWalletColumn: showWalletColumnTotal,
            elemMods: {
                common: 'yes'
            },
            total: this.commonTotal
        });

        result.push({
            elem: 'result-empty',
            elemMods: this.showEmptyResult ? '' : {
                hidden: 'yes'
            },
            content: iget2('b-campaigns-list', 'u-vas-net-kampaniy', 'У вас нет кампаний, соответствующих условиям поиска.')
        });

        return result;
    })
);
