block('b-campaigns-list').elem('total')(

    addJs()(true),

    match(function() {
        return !this.ctx.total;
    }).def()(function() {
        return '';
    }),

    content()(function() {
        var total = this.ctx.total,
            data = this.data,
            showWalletColumn = this.ctx.showWalletColumn,
            isWalletDisabled = this.ctx.isWalletDisabled,
            weekBudgetSum,
            dayBudgetSum,
            periodBudgetSum,
            numericCols,
            firstCols;

        firstCols = [
            {
                elem: 'cell',
                colspan: this.can.multiedit ? '2' : ''
            },
            {
                elem: 'cell',
                colspan: 2
            },
            {
                elem: 'cell',
                content: this.caption || iget2('b-campaigns-list', 'itogo-141', 'Итого:'),
                colspan: 2 + (this.can.see_owner ? 1 : 0)
            }
        ];

        if (showWalletColumn) {
            numericCols = ['clicks'];
        } else {
            numericCols = data.FORM.tab == 'arch' ? ['sum', 'clicks'] : ['clicks', 'sum'];
            (data.can.see_original_sum || isWalletDisabled) || (numericCols = numericCols.slice(0, 1));

            !showWalletColumn && numericCols.push('sum-rest');
        }

        numericCols = numericCols.map(function(numerical) {
            return {
                elem: 'cell',
                content: {
                    block: 'b-list-numeric',
                    js: true,
                    mods: {
                        type: numerical
                    },
                    content: total[numerical]
                }
            };
        });

        var res = firstCols.concat(numericCols);

        if (this.can.process_money_common && !showWalletColumn) res.push({
            elem: 'cell'
        });

        if (this.can.process_money_common && showWalletColumn) {

            weekBudgetSum = 0;
            dayBudgetSum = 0;
            periodBudgetSum = 0;

            this.ctx.campaigns && this.ctx.campaigns.forEach(function(campaign) {
                if (campaign.mediaType !== 'cpm_price') {
                    var strategy = campaign.strategy;

                    strategy && (strategy.search || strategy.net) &&
                    (weekBudgetSum += +(strategy.search.sum || strategy.net.sum) || 0);

                    campaign.day_budget &&
                        (dayBudgetSum += +campaign.day_budget.sum || 0);

                    strategy && (strategy.net.name === 'autobudget_max_impressions_custom_period' ||
                        strategy.net.name === 'autobudget_max_reach_custom_period' ||
                        strategy.net.name === 'autobudget_avg_cpv_custom_period') &&
                            (periodBudgetSum += +strategy.net.budget || 0);
                }
            });

            res.push({
                elem: 'cell',
                colspan: data.can.showPayColumn ?
                    data.can.see_original_sum ? 3 : 2 : data.can.see_original_sum ? 2 : 1,
                content: {
                    block: 'b-campaigns-list',
                    elem: 'total-items',
                    content: {
                        elem: 'total-items-wrapper',
                        content: this.ctx.campaigns && [
                                [dayBudgetSum, 'day-budget-sum'],
                                [weekBudgetSum, 'week-budget-sum'] ,
                                [periodBudgetSum, 'period-budget-sum']
                        ]
                            .map(function(pare) {
                                var mods = {
                                    type: pare[1]
                                };

                                pare[0] > 0 || (mods.hidden = 'yes');

                                return {
                                    elem: 'total-item',
                                    elemMods: mods,
                                    sum: u.formatShowsOrMoney(pare[0], 'money')
                                };
                            })
                    }
                }
            });
        }

        return res;
    })
);

// @TODO: грязненько!

block('b-campaigns-list').elem('total').elemMod('common', 'yes').content()(function() {
    return applyNext({
        caption: iget2('b-campaigns-list', 'vsego-142', 'Всего')
    });
});
